/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.engine;

import com.mojang.serialization.MapCodec;
import com.mrbysco.forcecraft.blockentities.ForceEngineBlockEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ForceEngineBlock
extends DirectionalBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_UP = Stream.of(Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)11.0, (double)4.0, (double)3.0, (double)15.0, (double)11.0, (double)13.0), Block.box((double)1.0, (double)4.0, (double)3.0, (double)5.0, (double)11.0, (double)13.0), Block.box((double)3.0, (double)4.0, (double)12.0, (double)13.0, (double)10.0, (double)14.0), Block.box((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)10.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_DOWN = Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)11.0, (double)5.0, (double)3.0, (double)15.0, (double)12.0, (double)13.0), Block.box((double)1.0, (double)5.0, (double)3.0, (double)5.0, (double)12.0, (double)13.0), Block.box((double)3.0, (double)6.0, (double)2.0, (double)13.0, (double)12.0, (double)4.0), Block.box((double)3.0, (double)6.0, (double)12.0, (double)13.0, (double)12.0, (double)14.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), Block.box((double)11.0, (double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)12.0), Block.box((double)1.0, (double)3.0, (double)5.0, (double)5.0, (double)13.0, (double)12.0), Block.box((double)3.0, (double)12.0, (double)6.0, (double)13.0, (double)14.0, (double)12.0), Block.box((double)3.0, (double)2.0, (double)6.0, (double)13.0, (double)4.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.box((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.box((double)4.0, (double)3.0, (double)11.0, (double)11.0, (double)13.0, (double)15.0), Block.box((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0, (double)5.0), Block.box((double)4.0, (double)12.0, (double)3.0, (double)10.0, (double)14.0, (double)13.0), Block.box((double)4.0, (double)2.0, (double)3.0, (double)10.0, (double)4.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), Block.box((double)11.0, (double)3.0, (double)4.0, (double)15.0, (double)13.0, (double)11.0), Block.box((double)1.0, (double)3.0, (double)4.0, (double)5.0, (double)13.0, (double)11.0), Block.box((double)3.0, (double)2.0, (double)4.0, (double)13.0, (double)4.0, (double)10.0), Block.box((double)3.0, (double)12.0, (double)4.0, (double)13.0, (double)14.0, (double)10.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.box((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), Block.box((double)5.0, (double)3.0, (double)11.0, (double)12.0, (double)13.0, (double)15.0), Block.box((double)5.0, (double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)5.0), Block.box((double)6.0, (double)2.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0), Block.box((double)6.0, (double)12.0, (double)3.0, (double)12.0, (double)14.0, (double)13.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final MapCodec<ForceEngineBlock> CODEC = ForceEngineBlock.simpleCodec(ForceEngineBlock::new);

    public ForceEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof ForceEngineBlockEntity) {
            IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)hit.getDirection());
            if (handler != null) {
                if (player.getItemInHand(handIn).getCapability(Capabilities.FluidHandler.ITEM) != null) {
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (Level)level, (BlockPos)pos, (Direction)hit.getDirection());
                } else if (!level.isClientSide) {
                    player.openMenu((MenuProvider)((ForceEngineBlockEntity)blockentity), pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> super.getShape(state, level, pos, context);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVE});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirrorIn.mirror((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(direction.getOpposite()));
        return blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == direction ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos()))) : (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)ACTIVE), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)ACTIVE), 2);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ForceEngineBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ForceEngineBlock.createEngineTicker(level, blockEntityType, ForceRegistry.FORCE_ENGINE_BLOCK_ENTITY.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createEngineTicker(Level level, BlockEntityType<T> p_151989_, BlockEntityType<? extends ForceEngineBlockEntity> forceEngineBlockEntity) {
        return level.isClientSide ? null : ForceEngineBlock.createTickerHelper(p_151989_, forceEngineBlockEntity, ForceEngineBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public static ToIntFunction<BlockState> getLightValueActive(int lightValue) {
        return state -> (Boolean)state.getValue((Property)ACTIVE) != false ? lightValue : 0;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)ACTIVE)).booleanValue()) {
            Direction direction = (Direction)stateIn.getValue((Property)FACING);
            double d0 = (double)pos.getX() + 0.55 - (double)(rand.nextFloat() * 0.1f);
            double d1 = (double)pos.getY() + 0.55 - (double)(rand.nextFloat() * 0.1f);
            double d2 = (double)pos.getZ() + 0.55 - (double)(rand.nextFloat() * 0.1f);
            double d3 = 0.4f - (rand.nextFloat() + rand.nextFloat()) * 0.4f;
            if (rand.nextInt(5) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + (double)direction.getStepX() * d3, d1 + (double)direction.getStepY() * d3, d2 + (double)direction.getStepZ() * d3, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ForceEngineBlockEntity) {
                ForceEngineBlockEntity engineTile = (ForceEngineBlockEntity)blockEntity;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)engineTile.inputHandler.getStackInSlot(0));
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)engineTile.inputHandler.getStackInSlot(1));
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)engineTile.outputHandler.getStackInSlot(0));
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)engineTile.outputHandler.getStackInSlot(1));
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

