/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidHandlerWrapper
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    public static final String NBT_INPUT = "Input";
    public static final String NBT_OUTPUT = "Output";
    protected final FluidTank throttleTank;
    protected final FluidTank fuelTank;

    public FluidHandlerWrapper(FluidTank throttle, FluidTank fuel) {
        this.throttleTank = throttle;
        this.fuelTank = fuel;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.put(NBT_INPUT, (Tag)this.throttleTank.writeToNBT(new CompoundTag()));
        tag.put(NBT_OUTPUT, (Tag)this.fuelTank.writeToNBT(new CompoundTag()));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.contains(NBT_OUTPUT)) {
            this.fuelTank.readFromNBT(tag.getCompound(NBT_OUTPUT));
        }
        if (tag.contains(NBT_INPUT)) {
            this.throttleTank.readFromNBT(tag.getCompound(NBT_INPUT));
        }
    }

    public int getTanks() {
        return 2;
    }

    public FluidStack getFluidInTank(int tank) {
        switch (tank) {
            default: {
                return this.fuelTank.getFluid();
            }
            case 1: 
        }
        return this.throttleTank.getFluid();
    }

    public int getTankCapacity(int tank) {
        switch (tank) {
            default: {
                return this.fuelTank.getCapacity();
            }
            case 1: 
        }
        return this.throttleTank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        switch (tank) {
            default: {
                return this.fuelTank.isFluidValid(stack);
            }
            case 1: 
        }
        return this.throttleTank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (this.fuelTank.isFluidValid(resource)) {
            int count = this.fuelTank.fill(resource, action);
            return count < 1000 ? 0 : count;
        }
        int count = this.throttleTank.fill(resource, action);
        return count < 1000 ? 0 : count;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fuelTank.isFluidValid(resource)) {
            return this.fuelTank.drain(resource, action);
        }
        return this.throttleTank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fuelTank.getFluidAmount() > 0) {
            return this.fuelTank.drain(maxDrain, action);
        }
        return this.throttleTank.drain(maxDrain, action);
    }
}

