/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.forcecraft.registry.ForceEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ShakeUtil {
    public static void shakeScreen(Minecraft minecraft, float partialTicks, long finishTimeNano, PoseStack poseStack) {
        Player player;
        float effectScale = ((Double)minecraft.options.screenEffectScale().get()).floatValue();
        Entity entity = minecraft.getCameraEntity();
        if (entity instanceof Player && (player = (Player)entity).hasEffect(ForceEffects.SHAKING.get()) & effectScale > 0.0f) {
            float f = player.walkDist - player.walkDistO;
            float f1 = -(player.walkDist + f * partialTicks);
            float f2 = Mth.lerp((float)partialTicks, (float)player.oBob, (float)player.bob);
            float shakeAmount = effectScale * 0.005f;
            float time = (float)finishTimeNano / 1000.0f;
            float offsetX = (float)Math.sin(time * 0.5f) * shakeAmount;
            float rotationAngle = (float)Math.cos(time * 0.1f) * 2.5f * effectScale;
            poseStack.translate((double)offsetX, 0.0, 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(rotationAngle));
            poseStack.translate((double)(Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (double)(-Math.abs(Mth.cos((float)(f1 * (float)Math.PI)) * f2)), 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(Math.abs(Mth.cos((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
        }
    }
}

