/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.card;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrbysco.forcecraft.menu.ItemCardMenu;
import com.mrbysco.forcecraft.networking.message.SaveCardRecipePayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemCardScreen
extends AbstractContainerScreen<ItemCardMenu> {
    private static final ResourceLocation ITEM_CARD_GUI = new ResourceLocation("forcecraft", "textures/gui/crafting3x3.png");
    private static final Component saveText = Component.literal((String)"\u2714");
    private static final Component invalidText = Component.literal((String)"\u2718");
    private Button buttonSave;

    public ItemCardScreen(ItemCardMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void init() {
        super.init();
        this.titleLabelX = 29;
        this.buttonSave = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)saveText, button -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SaveCardRecipePayload()})).bounds(this.width / 2 + 62, this.height / 2 - 76, 20, 20).build());
    }

    public void containerTick() {
        super.containerTick();
        ItemStack resultStack = ((ItemCardMenu)this.getMenu()).getCraftResult().getItem(0);
        if (resultStack.isEmpty()) {
            if (!this.buttonSave.getMessage().getString().equals(invalidText.getString())) {
                this.buttonSave.setMessage(invalidText);
            }
            if (this.buttonSave.active) {
                this.buttonSave.active = false;
            }
        } else {
            if (!this.buttonSave.getMessage().getString().equals(saveText.getString())) {
                this.buttonSave.setMessage(saveText);
            }
            if (!this.buttonSave.active) {
                this.buttonSave.active = true;
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(ITEM_CARD_GUI, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }
}

