/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.infuser;

import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.client.gui.widgets.ProgressBar;
import com.mrbysco.forcecraft.client.util.RenderHelper;
import com.mrbysco.forcecraft.compat.patchouli.PatchouliCompat;
import com.mrbysco.forcecraft.menu.infuser.InfuserMenu;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;

public class InfuserScreen
extends AbstractContainerScreen<InfuserMenu> {
    private Inventory inventory;
    private ProgressBar infuserProgress;
    private final ResourceLocation INFO = new ResourceLocation("forcecraft", "textures/gui/container/info.png");
    private final ResourceLocation ENERGY = new ResourceLocation("forcecraft", "textures/gui/container/energy.png");
    private final ResourceLocation TEXTURE = new ResourceLocation("forcecraft", "textures/gui/container/forceinfuser.png");
    private static final WidgetSprites GUIDE_SPRITE = new WidgetSprites(new ResourceLocation("forcecraft", "infuser/guide"), new ResourceLocation("forcecraft", "infuser/guide_highlighted"));
    private static final WidgetSprites CHISEL = new WidgetSprites(new ResourceLocation("forcecraft", "infuser/chisel"), new ResourceLocation("forcecraft", "infuser/chisel_highlight"));
    private Button buttonInfuse;
    private Button buttonGuide;

    public InfuserScreen(InfuserMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.inventory = inv;
        this.imageHeight = 208;
    }

    protected void init() {
        super.init();
        this.infuserProgress = new ProgressBar(this.TEXTURE, ProgressBar.ProgressBarDirection.DOWN_TO_UP, 2, 20, this.leftPos + 134, this.topPos + 93, 176, 0);
        int btnSize = 13;
        int x = 123;
        int y = 16;
        this.buttonGuide = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + x, this.topPos + y, btnSize, btnSize, GUIDE_SPRITE, button -> {
            if (ModList.get().isLoaded("patchouli")) {
                PatchouliCompat.openBook();
            } else {
                this.inventory.player.displayClientMessage((Component)Component.translatable((String)"gui.forcecraft.infuser.patchouli"), false);
            }
        }, (Component)Component.translatable((String)"gui.forcecraft.infuser.button.guide")));
        x = 39;
        y = 101;
        this.buttonInfuse = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + x, this.topPos + y, btnSize, btnSize, CHISEL, button -> {
            ItemStack bookStack = ((InfuserMenu)this.menu).getTile().getBookInSlot();
            if (bookStack.isEmpty()) {
                this.inventory.player.displayClientMessage((Component)Component.translatable((String)"gui.forcecraft.infuser.nobook"), false);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((InfuserMenu)this.menu).containerId, 0);
            }
        }, (Component)Component.empty()));
    }

    protected void containerTick() {
        boolean flag2;
        boolean flag;
        super.containerTick();
        boolean bl = flag = ((InfuserMenu)this.getMenu()).validRecipe[0] == 1;
        if (this.buttonInfuse.visible != flag) {
            this.buttonInfuse.visible = flag;
        }
        boolean bl2 = flag2 = !((InfuserMenu)this.menu).getTile().getBookInSlot().isEmpty();
        if (this.buttonGuide.visible != flag2) {
            this.buttonGuide.visible = flag2;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.blit(this.TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.drawFluidBar(guiGraphics);
        this.drawEnergyBar(guiGraphics);
        this.drawProgressBar(guiGraphics);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> text;
        int actualMouseX = mouseX - (this.width - this.imageWidth) / 2;
        int actualMouseY = mouseY - (this.height - this.imageHeight) / 2;
        InfuserBlockEntity tile = ((InfuserMenu)this.menu).getTile();
        if (this.isHovering(123, 16, 12, 12, mouseX, mouseY) && tile.handler.getStackInSlot(9).isEmpty()) {
            text = new ArrayList<MutableComponent>();
            text.add(Component.translatable((String)"gui.forcecraft.infuser.help.tooltip").withStyle(ChatFormatting.GRAY));
            guiGraphics.renderComponentTooltip(this.font, text, actualMouseX, actualMouseY);
        }
        if (this.isHovering(39, 101, 12, 12, mouseX, mouseY)) {
            text = new ArrayList();
            if (((InfuserMenu)this.getMenu()).isWorkAllowed()) {
                if (((InfuserMenu)this.getMenu()).validRecipe[0] == 0) {
                    text.add(Component.translatable((String)"gui.forcecraft.infuser.missing.recipe").withStyle(ChatFormatting.RED));
                } else {
                    text.add(Component.translatable((String)"gui.forcecraft.infuser.start.tooltip").withStyle(ChatFormatting.GRAY));
                }
            } else {
                boolean modifiersEmpty = tile.areAllModifiersEmpty();
                if (!modifiersEmpty && tile.getEnergyStored() < tile.getEnergyCostPer()) {
                    text.add(Component.translatable((String)"gui.forcecraft.infuser.missing.rf.tooltip").withStyle(ChatFormatting.RED));
                } else {
                    text.add(Component.translatable((String)"gui.forcecraft.infuser.missing.tooltip").withStyle(ChatFormatting.RED));
                }
            }
            guiGraphics.renderComponentTooltip(this.font, text, actualMouseX, actualMouseY);
        }
        if (this.isHovering(156, 8, 12, 112, mouseX, mouseY)) {
            text = new ArrayList();
            MutableComponent tt = Component.literal((String)(tile.getEnergyStored() + " RF")).withStyle(ChatFormatting.GOLD);
            text.add(tt);
            guiGraphics.renderComponentTooltip(this.font, text, actualMouseX, actualMouseY);
        }
        if (this.isHovering(10, 41, 15, 82, mouseX, mouseY)) {
            text = new ArrayList();
            if (tile.getFluid() == null) {
                text.add(Component.translatable((String)"gui.forcecraft.infuser.empty.tooltip"));
            } else {
                text.add(Component.translatable((String)"fluid.forcecraft.fluid_force_source"));
                text.add(Component.literal((String)(tile.getFluidAmount() + " mb")).withStyle(ChatFormatting.YELLOW));
            }
            guiGraphics.renderComponentTooltip(this.font, text, actualMouseX, actualMouseY);
        }
    }

    private void drawFluidBar(GuiGraphics guiGraphics) {
        if (((InfuserMenu)this.menu).getTile() == null || ((InfuserMenu)this.menu).getTile().getFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((InfuserMenu)this.menu).getTile().getFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((InfuserMenu)this.getMenu()).getTile().getFluidAmount(), 50000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.leftPos + 8, this.topPos + 41, tankPercentage, 82);
        guiGraphics.blit(this.TEXTURE, this.leftPos + 8, this.topPos + 41, 188, 26, 16, 82);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics) {
        if (((InfuserMenu)this.menu).getTile() == null || ((InfuserMenu)this.menu).getTile().energyStorage.getMaxEnergyStored() <= 0) {
            return;
        }
        float energy = ((InfuserMenu)this.getMenu()).getTile().getEnergyStored();
        float capacity = ((InfuserMenu)this.menu).getTile().energyStorage.getMaxEnergyStored();
        float pct = Math.min(energy / capacity, 1.0f);
        float height = 107.0f;
        int width = 12;
        guiGraphics.blit(this.ENERGY, this.leftPos + 156, this.topPos + 13, 0.0f, 0.0f, width, (int)(107.0f * pct), width, 107);
    }

    private void drawProgressBar(GuiGraphics guiGraphics) {
        InfuserBlockEntity tile = ((InfuserMenu)this.menu).getTile();
        if (tile.canWork) {
            this.infuserProgress.setMin(tile.processTime).setMax(tile.maxProcessTime);
            this.infuserProgress.draw(guiGraphics);
        }
    }
}

