/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.pack;

import com.mrbysco.forcecraft.client.gui.widgets.ItemButton;
import com.mrbysco.forcecraft.networking.message.PackChangePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class RenameAndRecolorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forcecraft", "textures/gui/container/rename_screen.png");
    private ItemStack itemstack;
    private final InteractionHand usedHand;
    private EditBox textfield;
    private int selectedColor;

    protected RenameAndRecolorScreen(ItemStack stack, InteractionHand hand) {
        super((Component)Component.translatable((String)"gui.forcecraft.rename.title"));
        this.itemstack = stack.copy();
        this.usedHand = hand;
    }

    public static void openScreen(ItemStack packName, InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new RenameAndRecolorScreen(packName, hand));
    }

    protected void init() {
        super.init();
        this.selectedColor = this.itemstack.getOrCreateTag().getInt("Color");
        this.addRenderableWidget((GuiEventListener)ItemButton.builder(CommonComponents.GUI_DONE, this.itemstack, button -> {
            ItemButton itemButton = (ItemButton)button;
            ++this.selectedColor;
            if (this.selectedColor > 15) {
                this.selectedColor = 0;
            }
            CompoundTag tag = itemButton.getButtonStack().getOrCreateTag();
            tag.putInt("Color", this.selectedColor);
            itemButton.getButtonStack().setTag(tag);
            this.itemstack = itemButton.getButtonStack();
        }).bounds(this.width / 2 - 89, this.height / 2 + 5, 18, 18).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen((Screen)null)).bounds(this.width / 2 - 34, this.height / 2 + 3, 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PackChangePayload(this.usedHand, this.textfield.getValue(), this.selectedColor)});
            this.minecraft.setScreen((Screen)null);
        }).bounds(this.width / 2 + 31, this.height / 2 + 3, 60, 20).build());
        this.textfield = new EditBox(this.minecraft.font, this.width / 2 - 90, this.height / 2 - 24, 180, 20, (Component)Component.literal((String)"Name"));
        this.textfield.setMaxLength(31);
        this.textfield.setValue(this.itemstack.getHoverName().getString());
        this.textfield.setTextColor(-1);
        this.addWidget((GuiEventListener)this.textfield);
        this.setInitialFocus((GuiEventListener)this.textfield);
    }

    public void removed() {
        super.removed();
    }

    public void tick() {
        super.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int xSize = 197;
        int ySize = 66;
        int guiLeft = (this.width - xSize) / 2;
        int guiTop = (this.height - ySize) / 2;
        guiGraphics.blit(TEXTURE, guiLeft, guiTop, 0, 0, xSize, ySize);
        this.textfield.render(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Color"), (int)((double)this.width / 2.0 - 68.0), (int)((double)this.height / 2.0 + 9.0), 0x555555, false);
    }
}

