/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.forcecraft.client.ClientHandler;
import com.mrbysco.forcecraft.client.model.CreeperTotModel;
import com.mrbysco.forcecraft.client.renderer.layer.CreeperTotChargeLayer;
import com.mrbysco.forcecraft.entities.CreeperTotEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CreeperTotRenderer
extends MobRenderer<CreeperTotEntity, CreeperTotModel<CreeperTotEntity>> {
    private static final ResourceLocation CREEPER_TEXTURES = new ResourceLocation("forcecraft", "textures/entity/creeper_tot.png");

    public CreeperTotRenderer(EntityRendererProvider.Context context) {
        super(context, new CreeperTotModel(context.bakeLayer(ClientHandler.CREEPER_TOT)), 0.2f);
        this.addLayer((RenderLayer)new CreeperTotChargeLayer((RenderLayerParent<CreeperTotEntity, CreeperTotModel<CreeperTotEntity>>)this, context.getModelSet()));
    }

    protected void scale(CreeperTotEntity entitylivingbaseIn, PoseStack poseStack, float partialTickTime) {
        float f = entitylivingbaseIn.getSwelling(partialTickTime);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(CreeperTotEntity livingEntityIn, float partialTicks) {
        float f = livingEntityIn.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(CreeperTotEntity entity) {
        return CREEPER_TEXTURES;
    }
}

