/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.compat.jei;

import com.mrbysco.forcecraft.client.gui.furnace.ForceFurnaceScreen;
import com.mrbysco.forcecraft.compat.jei.infuser.InfuserCategory;
import com.mrbysco.forcecraft.compat.jei.multipleoutput.FreezingCategory;
import com.mrbysco.forcecraft.compat.jei.multipleoutput.GrindingCategory;
import com.mrbysco.forcecraft.menu.furnace.ForceFurnaceMenu;
import com.mrbysco.forcecraft.recipe.FreezingRecipe;
import com.mrbysco.forcecraft.recipe.GrindingRecipe;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation RECIPE_MULTIPLES_JEI = new ResourceLocation("forcecraft", "textures/gui/jei/multiples.png");
    public static final ResourceLocation RECIPE_INFUSER_JEI = new ResourceLocation("forcecraft", "textures/gui/jei/infuser.png");
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("forcecraft", "main");
    public static final ResourceLocation FREEZING = new ResourceLocation("forcecraft", "freezing");
    public static final ResourceLocation GRINDING = new ResourceLocation("forcecraft", "grinding");
    public static final ResourceLocation INFUSER = new ResourceLocation("forcecraft", "infuser");
    public static final RecipeType<FreezingRecipe> FREEZING_TYPE = RecipeType.create((String)"forcecraft", (String)"freezing", FreezingRecipe.class);
    public static final RecipeType<GrindingRecipe> GRINDING_TYPE = RecipeType.create((String)"forcecraft", (String)"grinding", GrindingRecipe.class);
    public static final RecipeType<InfuseRecipe> INFUSER_TYPE = RecipeType.create((String)"forcecraft", (String)"infuser", InfuseRecipe.class);
    @Nullable
    private IRecipeCategory<FreezingRecipe> freezingCategory;
    @Nullable
    private IRecipeCategory<GrindingRecipe> grindingCategory;
    @Nullable
    private IRecipeCategory<InfuseRecipe> infuserCategory;

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.BLACK_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.BLUE_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.BROWN_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.CYAN_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.GRAY_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.GREEN_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.LIME_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.MAGENTA_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.ORANGE_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.PINK_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.PURPLE_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.RED_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.WHITE_FORCE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.FREEZING_CORE.get()), new RecipeType[]{FREEZING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.GRINDING_CORE.get()), new RecipeType[]{GRINDING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForceRegistry.INFUSER.get()), new RecipeType[]{INFUSER_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[3];
        this.freezingCategory = new FreezingCategory(guiHelper);
        iRecipeCategoryArray[0] = this.freezingCategory;
        this.grindingCategory = new GrindingCategory(guiHelper);
        iRecipeCategoryArray[1] = this.grindingCategory;
        this.infuserCategory = new InfuserCategory(guiHelper);
        iRecipeCategoryArray[2] = this.infuserCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ForceFurnaceScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ForceFurnaceMenu.class, ForceMenus.FORCE_FURNACE.get(), RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(ForceFurnaceMenu.class, ForceMenus.FORCE_FURNACE.get(), FREEZING_TYPE, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(ForceFurnaceMenu.class, ForceMenus.FORCE_FURNACE.get(), GRINDING_TYPE, 0, 1, 3, 36);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (FREEZING_TYPE != null);
        assert (GRINDING_TYPE != null);
        assert (INFUSER_TYPE != null);
        ClientLevel world = Objects.requireNonNull(Minecraft.getInstance().level);
        registration.addRecipes(FREEZING_TYPE, world.getRecipeManager().getAllRecipesFor(ForceRecipes.FREEZING.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(GRINDING_TYPE, world.getRecipeManager().getAllRecipesFor(ForceRecipes.GRINDING.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(INFUSER_TYPE, world.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }
}

