/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.compat.jei.multipleoutput;

import com.mrbysco.forcecraft.compat.jei.JeiCompat;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public abstract class AbstractMultiOutputCategory<T extends MultipleOutputFurnaceRecipe>
implements IRecipeCategory<T> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final boolean showChance;

    public AbstractMultiOutputCategory(IGuiHelper guiHelper, Block icon, String translationKey, int yOffset, boolean showChance) {
        this.background = guiHelper.createDrawable(JeiCompat.RECIPE_MULTIPLES_JEI, 0, yOffset, 140, 37);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)icon));
        this.localizedName = Component.translatable((String)translationKey);
        this.showChance = showChance;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 10).addItemStack((ItemStack)((MultipleOutputFurnaceRecipe)((Object)recipe)).getRecipeOutputs().get(0));
        if (((MultipleOutputFurnaceRecipe)((Object)recipe)).getRecipeOutputs().size() > 1) {
            IRecipeSlotBuilder secondOutputBuilder = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 10).addItemStack((ItemStack)((MultipleOutputFurnaceRecipe)((Object)recipe)).getRecipeOutputs().get(1));
            if (this.showChance) {
                secondOutputBuilder.addTooltipCallback((IRecipeSlotTooltipCallback)new ChanceTooltip((MultipleOutputFurnaceRecipe)((Object)recipe)));
            }
        }
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public static class ChanceTooltip
    implements IRecipeSlotTooltipCallback {
        private final MultipleOutputFurnaceRecipe recipe;

        public ChanceTooltip(MultipleOutputFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            tooltip.add((Component)Component.literal((String)(this.recipe.getSecondaryChance() * 100.0f + " ")).append((Component)Component.translatable((String)"forcecraft.gui.jei.category.grinding.tooltip")).withStyle(ChatFormatting.YELLOW));
        }
    }
}

