/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen;

import com.mrbysco.forcecraft.datagen.assets.ForceBlockModelProvider;
import com.mrbysco.forcecraft.datagen.assets.ForceBlockStateProvider;
import com.mrbysco.forcecraft.datagen.assets.ForceItemModelProvider;
import com.mrbysco.forcecraft.datagen.assets.ForceLanguageProvider;
import com.mrbysco.forcecraft.datagen.data.ForceDamageTypeProvider;
import com.mrbysco.forcecraft.datagen.data.ForceLootModifierProvider;
import com.mrbysco.forcecraft.datagen.data.ForceLootProvider;
import com.mrbysco.forcecraft.datagen.data.ForceRecipeProvider;
import com.mrbysco.forcecraft.datagen.data.tags.ForceBlockTagProvider;
import com.mrbysco.forcecraft.datagen.data.tags.ForceDamageTypeTagProvider;
import com.mrbysco.forcecraft.datagen.data.tags.ForceItemTagProvider;
import com.mrbysco.forcecraft.datagen.patchouli.PatchouliProvider;
import com.mrbysco.forcecraft.world.feature.ForceBiomeModifiers;
import com.mrbysco.forcecraft.world.feature.ForceFeatureKeys;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForceDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> ForceDataGen.getProvider().full());
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new ForceLootProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new ForceRecipeProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new PatchouliProvider(packOutput));
            ForceBlockTagProvider provider = new ForceBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(event.includeServer(), (DataProvider)provider);
            generator.addProvider(event.includeServer(), (DataProvider)new ForceItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)provider, existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new ForceDamageTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new ForceLootModifierProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(ForceDataGen::getProvider), Set.of("forcecraft")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new ForceLanguageProvider(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ForceBlockModelProvider(packOutput, existingFileHelper));
            generator.addProvider(event.includeClient(), (DataProvider)new ForceBlockStateProvider(packOutput, existingFileHelper));
            generator.addProvider(event.includeClient(), (DataProvider)new ForceItemModelProvider(packOutput, existingFileHelper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.DAMAGE_TYPE, ForceDamageTypeProvider::bootstrap);
        registryBuilder.add(Registries.CONFIGURED_FEATURE, ForceFeatureKeys::configuredBootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, ForceFeatureKeys::placedBootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ForceBiomeModifiers::modifierBootstrap);
        registryBuilder.add(Registries.BIOME, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

