/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data;

import com.mrbysco.forcecraft.datagen.data.SpoilsBagLootTableProvider;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ForceLootProvider
extends LootTableProvider {
    public ForceLootProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ForceBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ForceEntityLoot::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(SpoilsBagLootTableProvider::new, LootContextParamSets.GIFT)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationContext) {
        List<ResourceLocation> ignored = List.of(ForceTables.TIER_1, ForceTables.TIER_2, ForceTables.TIER_3);
        map.forEach((name, table) -> {
            if (!ignored.contains(name)) {
                table.validate(validationContext);
            }
        });
    }

    private static class ForceEntityLoot
    extends EntityLootSubProvider {
        protected ForceEntityLoot() {
            super(FeatureFlags.REGISTRY.allFlags());
        }

        public void generate() {
            this.add(ForceEntities.COLD_CHICKEN.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHICKEN).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add(ForceEntities.COLD_COW.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEEF).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add(ForceEntities.COLD_PIG.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PORKCHOP).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add(ForceEntities.ANGRY_ENDERMAN.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add(ForceEntities.ENDER_TOT.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().name("spoils").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceWithLootingCondition.randomChanceAndLootingBoost((float)0.025f, (float)0.01f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.SPOILS_BAG.get())))));
            this.add(ForceEntities.CREEPER_TOT.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.PILE_OF_GUNPOWDER.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().name("head").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceWithLootingCondition.randomChanceAndLootingBoost((float)0.025f, (float)0.01f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CREEPER_HEAD))).withPool(LootPool.lootPool().name("spoils").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceWithLootingCondition.randomChanceAndLootingBoost((float)0.025f, (float)0.01f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.SPOILS_BAG.get())))));
            this.add(ForceEntities.BLUE_CHU_CHU.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.BLUE_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(this.killedByFrog().invert())).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.BLUE_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(this.killedByFrog())).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)SlimePredicate.sized((MinMaxBounds.Ints)MinMaxBounds.Ints.exactly((int)1)))))));
            this.add(ForceEntities.GOLD_CHU_CHU.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.GOLD_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(this.killedByFrog().invert())).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.GOLD_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(this.killedByFrog())).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)SlimePredicate.sized((MinMaxBounds.Ints)MinMaxBounds.Ints.exactly((int)1)))))));
            this.add(ForceEntities.GREEN_CHU_CHU.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.GREEN_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(this.killedByFrog().invert())).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.GREEN_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(this.killedByFrog())).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)SlimePredicate.sized((MinMaxBounds.Ints)MinMaxBounds.Ints.exactly((int)1)))))));
            this.add(ForceEntities.RED_CHU_CHU.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.RED_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(this.killedByFrog().invert())).add(LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.RED_CHU_JELLY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(this.killedByFrog())).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)SlimePredicate.sized((MinMaxBounds.Ints)MinMaxBounds.Ints.exactly((int)1)))))));
            this.add(ForceEntities.FAIRY.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("main")));
        }

        protected boolean canHaveLootTable(EntityType<?> p_249029_) {
            return super.canHaveLootTable(p_249029_);
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ForceEntities.ENTITY_TYPES.getEntries().stream().map(DeferredHolder::get);
        }
    }

    private static class ForceBlockLoot
    extends BlockLootSubProvider {
        protected ForceBlockLoot() {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags());
        }

        public void generate() {
            this.add((Block)ForceRegistry.POWER_ORE.get(), ore -> ForceBlockLoot.createSilkTouchDispatchTable((Block)ore, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)ForceRegistry.POWER_ORE_ITEM.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.FORCE_GEM.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))))));
            this.add((Block)ForceRegistry.DEEPSLATE_POWER_ORE.get(), ore -> ForceBlockLoot.createSilkTouchDispatchTable((Block)ore, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)ForceRegistry.POWER_ORE_ITEM.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)ForceRegistry.FORCE_GEM.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))))));
            this.dropSelf((Block)ForceRegistry.INFUSER.get());
            this.add((Block)ForceRegistry.FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.BLACK_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.BLACK_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.BLUE_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.BLUE_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.BROWN_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.BROWN_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.CYAN_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.CYAN_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.GRAY_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.GRAY_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.GREEN_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.GREEN_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.LIME_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.LIME_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.MAGENTA_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.MAGENTA_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.ORANGE_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.ORANGE_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.PINK_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.PINK_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.PURPLE_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.PURPLE_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.RED_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.RED_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.WHITE_FORCE_FURNACE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.WHITE_FORCE_FURNACE.get()));
            this.add((Block)ForceRegistry.FORCE_ENGINE.get(), this.createNameableBlockEntityTable((Block)ForceRegistry.FORCE_ENGINE.get()));
            this.dropSelf((Block)ForceRegistry.FORCE_SAPLING.get());
            this.dropSelf((Block)ForceRegistry.FORCE_LOG.get());
            this.dropSelf((Block)ForceRegistry.FORCE_WOOD.get());
            this.dropSelf((Block)ForceRegistry.FORCE_PLANKS.get());
            this.add((Block)ForceRegistry.FORCE_LEAVES.get(), leaves -> this.createOakLeavesDrops((Block)leaves, (Block)ForceRegistry.FORCE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)ForceRegistry.FORCE_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_RED_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_ORANGE_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_GREEN_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BLUE_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_WHITE_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BLACK_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BROWN_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_LIGHT_BLUE_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_MAGENTA_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_PINK_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_LIGHT_GRAY_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_LIME_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_CYAN_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_PURPLE_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_GRAY_TORCH.get());
            this.dropSelf((Block)ForceRegistry.TIME_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_RED_TORCH.get(), (ItemLike)ForceRegistry.FORCE_RED_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_ORANGE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_ORANGE_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_GREEN_TORCH.get(), (ItemLike)ForceRegistry.FORCE_GREEN_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_BLUE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_BLUE_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_WHITE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_WHITE_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_BLACK_TORCH.get(), (ItemLike)ForceRegistry.FORCE_BLACK_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_BROWN_TORCH.get(), (ItemLike)ForceRegistry.FORCE_BROWN_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_LIGHT_BLUE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_LIGHT_BLUE_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_MAGENTA_TORCH.get(), (ItemLike)ForceRegistry.FORCE_MAGENTA_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_PINK_TORCH.get(), (ItemLike)ForceRegistry.FORCE_PINK_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_LIGHT_GRAY_TORCH.get(), (ItemLike)ForceRegistry.FORCE_LIGHT_GRAY_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_LIME_TORCH.get(), (ItemLike)ForceRegistry.FORCE_LIME_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_CYAN_TORCH.get(), (ItemLike)ForceRegistry.FORCE_CYAN_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_PURPLE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_PURPLE_TORCH.get());
            this.dropOther((Block)ForceRegistry.WALL_FORCE_GRAY_TORCH.get(), (ItemLike)ForceRegistry.FORCE_GRAY_TORCH.get());
            this.dropSelf((Block)ForceRegistry.WALL_TIME_TORCH.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_RED.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_YELLOW.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_GREEN.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_BLUE.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_WHITE.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_BLACK.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_BROWN.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_ORANGE.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_MAGENTA.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_PINK.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_LIME.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_CYAN.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_PURPLE.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_GRAY.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK.get());
            this.dropSelf((Block)ForceRegistry.FORCE_PLANK_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_RED_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_YELLOW_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_GREEN_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_BLUE_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_WHITE_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_BLACK_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_BROWN_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_ORANGE_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_MAGENTA_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_PINK_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_LIME_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_CYAN_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_PURPLE_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_GRAY_STAIRS.get());
            this.dropSelf((Block)ForceRegistry.FORCE_BRICK_STAIRS.get());
            this.add((Block)ForceRegistry.FORCE_PLANK_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_PLANK_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_RED_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_RED_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_YELLOW_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_YELLOW_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_GREEN_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_GREEN_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_BLUE_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_BLUE_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_WHITE_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_WHITE_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_BLACK_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_BLACK_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_BROWN_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_BROWN_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_ORANGE_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_ORANGE_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_MAGENTA_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_MAGENTA_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_PINK_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_PINK_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_LIME_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_LIME_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_CYAN_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_CYAN_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_PURPLE_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_PURPLE_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_GRAY_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_GRAY_SLAB.get()));
            this.add((Block)ForceRegistry.FORCE_BRICK_SLAB.get(), this.createSlabItemTable((Block)ForceRegistry.FORCE_BRICK_SLAB.get()));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForceRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

