/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data.recipe;

import com.mrbysco.forcecraft.recipe.FreezingRecipe;
import com.mrbysco.forcecraft.recipe.GrindingRecipe;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MultipleOutputRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<ItemStack> results = NonNullList.create();
    private final Ingredient ingredient;
    private final float experience;
    private final int time;
    private final float chance;
    @Nullable
    private String group;
    private final RecipeType<? extends MultipleOutputFurnaceRecipe> type;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public MultipleOutputRecipeBuilder(RecipeType<? extends MultipleOutputFurnaceRecipe> type, Ingredient ingredient, float pExperience, int grindingTime) {
        this.type = type;
        this.ingredient = ingredient;
        this.experience = pExperience;
        this.time = grindingTime;
        this.chance = 0.0f;
    }

    public MultipleOutputRecipeBuilder(RecipeType<? extends MultipleOutputFurnaceRecipe> type, Ingredient ingredient, float chance, float pExperience, int grindingTime) {
        this.type = type;
        this.ingredient = ingredient;
        this.experience = pExperience;
        this.time = grindingTime;
        this.chance = chance;
    }

    public static MultipleOutputRecipeBuilder freezing(Ingredient ingredient, float experience, int freezingTime) {
        return new MultipleOutputRecipeBuilder(ForceRecipes.FREEZING.get(), ingredient, experience, freezingTime);
    }

    public static MultipleOutputRecipeBuilder freezing(ItemLike input, float experience, int freezingTime) {
        return new MultipleOutputRecipeBuilder(ForceRecipes.FREEZING.get(), Ingredient.of((ItemLike[])new ItemLike[]{input}), experience, freezingTime);
    }

    public static MultipleOutputRecipeBuilder grinding(Ingredient ingredient, float chance, float experience, int processTime) {
        return new MultipleOutputRecipeBuilder(ForceRecipes.GRINDING.get(), ingredient, chance, experience, processTime);
    }

    public static MultipleOutputRecipeBuilder grinding(ItemLike input, float chance, float experience, int processTime) {
        return new MultipleOutputRecipeBuilder(ForceRecipes.GRINDING.get(), Ingredient.of((ItemLike[])new ItemLike[]{input}), chance, experience, processTime);
    }

    public MultipleOutputRecipeBuilder setResult(ItemLike item, int count) {
        this.results.add((Object)new ItemStack(item, count));
        return this;
    }

    public MultipleOutputRecipeBuilder setResult(ItemStack stack) {
        this.results.add((Object)stack);
        return this;
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item getResult() {
        return ((ItemStack)this.results.get(0)).getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        Advancement.Builder advancement$builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        if (this.results.isEmpty() || this.results.size() > 2) {
            throw new IllegalStateException("Must have between 1 and 2 results.");
        }
        if (this.type == ForceRecipes.FREEZING.get()) {
            FreezingRecipe recipe = new FreezingRecipe(this.group == null ? "" : this.group, this.ingredient, this.results, this.experience, this.time);
            output.accept(id, (Recipe)recipe, advancement$builder.build(id.withPrefix("recipes/freezing/")));
        } else if (this.type == ForceRecipes.GRINDING.get()) {
            GrindingRecipe recipe = new GrindingRecipe(this.group == null ? "" : this.group, this.ingredient, this.results, this.chance, this.experience, this.time);
            output.accept(id, (Recipe)recipe, advancement$builder.build(id.withPrefix("recipes/grinding/")));
        }
    }
}

