/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.entities.goal.EatGrassToRestoreGoal;
import com.mrbysco.forcecraft.registry.ForceEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;

public class ColdPigEntity
extends Pig
implements IColdMob {
    private int grassTimer;
    private EatGrassToRestoreGoal eatGrassGoal;
    private ResourceLocation originalTypeLocation;

    public ColdPigEntity(EntityType<? extends Pig> type, Level level) {
        super(type, level);
        this.originalTypeLocation = new ResourceLocation("minecraft", "pig");
    }

    public ColdPigEntity(Level level, ResourceLocation typeLocation) {
        super(ForceEntities.COLD_PIG.get(), level);
        if (typeLocation != null) {
            this.originalTypeLocation = typeLocation;
        }
    }

    public boolean canMate(Animal otherAnimal) {
        return false;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.originalTypeLocation = compound.getString("OriginalMob").isEmpty() ? new ResourceLocation("minecraft", "pig") : new ResourceLocation(compound.getString("OriginalMob"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("OriginalMob", this.originalTypeLocation.toString());
    }

    protected void registerGoals() {
        this.eatGrassGoal = new EatGrassToRestoreGoal((Mob)this);
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)this.eatGrassGoal);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Pig.createAttributes();
    }

    protected void customServerAiStep() {
        this.grassTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.customServerAiStep();
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            this.grassTimer = Math.max(0, this.grassTimer - 1);
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.grassTimer = 40;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.grassTimer <= 0) {
            return 0.0f;
        }
        if (this.grassTimer >= 4 && this.grassTimer <= 36) {
            return 1.0f;
        }
        return this.grassTimer < 4 ? ((float)this.grassTimer - p_70894_1_) / 4.0f : -((float)(this.grassTimer - 40) - p_70894_1_) / 4.0f;
    }

    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.grassTimer > 4 && this.grassTimer <= 36) {
            float f = ((float)(this.grassTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.grassTimer > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    @Override
    public ResourceLocation getOriginal() {
        return this.originalTypeLocation;
    }
}

