/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CreeperTotEntity
extends Creeper {
    public CreeperTotEntity(EntityType<? extends Creeper> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 4.0);
    }

    public EntityType<? extends Creeper> getType() {
        return ForceEntities.CREEPER_TOT.get();
    }

    public void explodeCreeper() {
        this.level().broadcastEntityEvent((Entity)this, (byte)17);
        if (!this.level().isClientSide) {
            this.dead = true;
            this.playSound(SoundEvents.GENERIC_EXPLODE, 4.0f, (1.0f + (this.level().random.nextFloat() - this.level().random.nextFloat()) * 0.2f) * 0.7f);
            if (this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) && this.getRandom().nextInt(4) == 0) {
                this.spawnAtLocation(new ItemStack((ItemLike)ForceRegistry.PILE_OF_GUNPOWDER.get(), this.getRandom().nextInt(2) + 1));
            }
            this.discard();
        }
    }

    public void summonFireworkParticles(CompoundTag fireworksTag, double yOffset) {
        if (fireworksTag != null) {
            Vec3 vector3d = this.getDeltaMovement();
            this.level().createFireworks(this.getX(), this.getY() + yOffset, this.getZ(), vector3d.x, vector3d.y, vector3d.z, fireworksTag);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 17 && this.level().isClientSide) {
            for (int i = 0; i < 4; ++i) {
                this.summonFireworkParticles(this.getFireworkTag(), 0.5);
            }
            this.summonFireworkParticles(this.getCreeperFireworkTag(), 2.5);
        }
        super.handleEntityEvent(id);
    }

    public CompoundTag getFireworkTag() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Flicker", true);
        int[] colors = new int[16];
        for (int i = 0; i < 16; ++i) {
            colors[i] = DyeColor.byId((int)i).getFireworkColor();
        }
        tag.putIntArray("Colors", colors);
        tag.putByte("Type", (byte)0);
        ListTag explosions = new ListTag();
        explosions.add((Object)tag);
        CompoundTag fireworkTag = new CompoundTag();
        fireworkTag.put("Explosions", (Tag)explosions);
        return fireworkTag;
    }

    public CompoundTag getCreeperFireworkTag() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Flicker", true);
        int[] colors = new int[]{DyeColor.LIME.getFireworkColor()};
        tag.putIntArray("Colors", colors);
        tag.putByte("Type", (byte)3);
        ListTag explosions = new ListTag();
        explosions.add((Object)tag);
        CompoundTag fireworkTag = new CompoundTag();
        fireworkTag.put("Explosions", (Tag)explosions);
        return fireworkTag;
    }
}

