/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.entities.AngryEndermanEntity;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class EnderTotEntity
extends EnderMan {
    private static final ResourceLocation TOT_HOLDABLE = new ResourceLocation("forcecraft", "endertot_holdable");

    public EnderTotEntity(EntityType<? extends EnderMan> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(BlockPathTypes.WATER, 8.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new StareGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new PlaceBlockGoal(this));
        this.goalSelector.addGoal(11, (Goal)new TakeBlockGoal(this));
        this.targetSelector.addGoal(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((EnderTotEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return 1.35f;
    }

    public boolean isBaby() {
        return true;
    }

    public boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive() && !this.isInWaterOrBubble()) {
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 32.0;
            double d1 = this.getY() + (double)(this.random.nextInt(32) - 16);
            double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    public void die(DamageSource cause) {
        Entity entitySource = cause.getDirectEntity();
        if (entitySource instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entitySource;
            if (!this.level().isClientSide) {
                int total = this.getRandom().nextInt(2) + 1;
                for (int i = 0; i < total; ++i) {
                    AngryEndermanEntity endermanEntity = (AngryEndermanEntity)ForceEntities.ANGRY_ENDERMAN.get().create(this.level());
                    if (endermanEntity == null) continue;
                    endermanEntity.moveTo(this.getX(), this.getY() + 0.5, this.getZ(), 0.0f, 0.0f);
                    endermanEntity.setTarget(livingEntity);
                    this.level().addFreshEntity((Entity)endermanEntity);
                }
            }
        }
        super.die(cause);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    static class StareGoal
    extends Goal {
        private final EnderTotEntity endertot;
        private LivingEntity targetPlayer;

        public StareGoal(EnderTotEntity endertotIn) {
            this.endertot = endertotIn;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.targetPlayer = this.endertot.getTarget();
            if (!(this.targetPlayer instanceof Player)) {
                return false;
            }
            double d0 = this.targetPlayer.distanceToSqr((Entity)this.endertot);
            return !(d0 > 256.0) && this.endertot.isLookingAtMe((Player)this.targetPlayer);
        }

        public void start() {
            this.endertot.getNavigation().stop();
        }

        public void tick() {
            this.endertot.getLookControl().setLookAt(this.targetPlayer.getX(), this.targetPlayer.getEyeY(), this.targetPlayer.getZ());
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EnderTotEntity endertot;

        public PlaceBlockGoal(EnderTotEntity totEntity) {
            this.endertot = totEntity;
        }

        public boolean canUse() {
            if (this.endertot.getCarriedBlock() == null) {
                return false;
            }
            if (!EventHooks.getMobGriefingEvent((Level)this.endertot.level(), (Entity)this.endertot)) {
                return false;
            }
            return this.endertot.getRandom().nextInt(2000) == 0;
        }

        public void tick() {
            RandomSource random = this.endertot.getRandom();
            Level world = this.endertot.level();
            int i = Mth.floor((double)(this.endertot.getX() - 1.0 + random.nextDouble() * 2.0));
            int j = Mth.floor((double)(this.endertot.getY() + random.nextDouble() * 2.0));
            int k = Mth.floor((double)(this.endertot.getZ() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.getBlockState(blockpos);
            BlockPos belowPos = blockpos.below();
            BlockState belowState = world.getBlockState(belowPos);
            BlockState carriedState = this.endertot.getCarriedBlock();
            if (carriedState != null && this.canPlaceBlock(world, blockpos, carriedState = Block.updateFromNeighbourShapes((BlockState)carriedState, (LevelAccessor)this.endertot.level(), (BlockPos)blockpos), blockstate, belowState, belowPos) && !EventHooks.onBlockPlace((Entity)this.endertot, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)belowPos), (Direction)Direction.UP)) {
                world.setBlock(blockpos, carriedState, 3);
                this.endertot.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(Level level, BlockPos p_32560_, BlockState p_32561_, BlockState p_32562_, BlockState p_32563_, BlockPos p_32564_) {
            return p_32562_.isAir() && !p_32563_.isAir() && !p_32563_.is(Blocks.BEDROCK) && !p_32563_.is(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_32563_.isCollisionShapeFullBlock((BlockGetter)level, p_32564_) && p_32561_.canSurvive((LevelReader)level, p_32560_) && level.getEntities((Entity)this.endertot, AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)p_32560_))).isEmpty();
        }
    }

    static class TakeBlockGoal
    extends Goal {
        private final EnderTotEntity endertot;

        public TakeBlockGoal(EnderTotEntity endertotIn) {
            this.endertot = endertotIn;
        }

        public boolean canUse() {
            if (this.endertot.getCarriedBlock() != null) {
                return false;
            }
            if (!EventHooks.getMobGriefingEvent((Level)this.endertot.level(), (Entity)this.endertot)) {
                return false;
            }
            return this.endertot.getRandom().nextInt(20) == 0;
        }

        public void tick() {
            RandomSource random = this.endertot.getRandom();
            Level world = this.endertot.level();
            int i = Mth.floor((double)(this.endertot.getX() - 2.0 + random.nextDouble() * 4.0));
            int j = Mth.floor((double)(this.endertot.getY() + random.nextDouble() * 3.0));
            int k = Mth.floor((double)(this.endertot.getZ() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.getBlockState(blockpos);
            Vec3 vector3d = new Vec3((double)Mth.floor((double)this.endertot.getX()) + 0.5, (double)j + 0.5, (double)Mth.floor((double)this.endertot.getZ()) + 0.5);
            Vec3 vector3d1 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockHitResult = world.clip(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.endertot));
            boolean flag = blockHitResult.getBlockPos().equals((Object)blockpos);
            if (blockstate.is(ForceTags.ENDERTOT_HOLDABLE) && flag) {
                world.removeBlock(blockpos, false);
                this.endertot.setCarriedBlock(blockstate.getBlock().defaultBlockState());
            }
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EnderTotEntity endertot;
        private Player player;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.forCombat().ignoreLineOfSight();

        public FindPlayerGoal(EnderTotEntity enderTotIn, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((Mob)enderTotIn, Player.class, 10, false, false, p_i241912_2_);
            this.endertot = enderTotIn;
            this.startAggroTargetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(livingEntity -> enderTotIn.isLookingAtMe((Player)livingEntity));
        }

        public boolean canUse() {
            this.player = this.endertot.level().getNearestPlayer(this.startAggroTargetConditions, (LivingEntity)this.endertot);
            return this.player != null;
        }

        public void start() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.endertot.setBeingStaredAt();
        }

        public void stop() {
            this.player = null;
            super.stop();
        }

        public boolean canContinueToUse() {
            if (this.player != null) {
                if (!this.endertot.isLookingAtMe(this.player)) {
                    return false;
                }
                this.endertot.lookAt((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.target != null && this.continueAggroTargetConditions.test((LivingEntity)this.endertot, this.target) || super.canContinueToUse();
        }

        public void tick() {
            if (this.endertot.getTarget() == null) {
                super.setTarget((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.target = this.player;
                    this.player = null;
                    super.start();
                }
            } else {
                if (this.target != null && !this.endertot.isPassenger()) {
                    if (this.endertot.isLookingAtMe((Player)this.target)) {
                        if (this.target.distanceToSqr((Entity)this.endertot) < 16.0) {
                            this.endertot.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.target.distanceToSqr((Entity)this.endertot) > 128.0 && this.teleportTime++ >= 30 && this.endertot.teleportTowards((Entity)this.target)) {
                        this.teleportTime = 0;
                    }
                }
                super.tick();
            }
        }
    }
}

