/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.projectile;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.banemodifier.BaneModifierAttachment;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.ForceUtils;
import com.mrbysco.forcecraft.util.MobUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ForceArrowEntity
extends Arrow {
    private static final EntityDataAccessor<Boolean> ENDER = SynchedEntityData.defineId(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BANE = SynchedEntityData.defineId(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPEED = SynchedEntityData.defineId(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GLOWING = SynchedEntityData.defineId(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LUCK = SynchedEntityData.defineId(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BLEEDING = SynchedEntityData.defineId(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ForceArrowEntity(EntityType<? extends Arrow> type, Level level) {
        super(type, level);
    }

    public ForceArrowEntity(Level level, LivingEntity shooter) {
        super(ForceEntities.FORCE_ARROW.get(), level);
        this.setOwner((Entity)shooter);
    }

    public void shootFromRotation(Entity projectile, float x, float y, float z, float velocity, float inaccuracy) {
        float newVelocity = this.isSpeedy() ? velocity + 1.0f : velocity;
        super.shootFromRotation(projectile, x, y, z, newVelocity, inaccuracy);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(ENDER, (Object)false);
        this.entityData.define(BANE, (Object)false);
        this.entityData.define(LUCK, (Object)0);
        this.entityData.define(BLEEDING, (Object)0);
        this.entityData.define(SPEED, (Object)false);
        this.entityData.define(GLOWING, (Object)false);
    }

    public boolean isBane() {
        return (Boolean)this.entityData.get(BANE);
    }

    public void setBane() {
        this.entityData.set(BANE, (Object)true);
    }

    public boolean isSpeedy() {
        return (Boolean)this.entityData.get(SPEED);
    }

    public void setSpeedy() {
        this.entityData.set(SPEED, (Object)true);
    }

    public boolean isEnder() {
        return (Boolean)this.entityData.get(ENDER);
    }

    public void setEnder() {
        this.entityData.set(ENDER, (Object)true);
    }

    public boolean appliesGlowing() {
        return (Boolean)this.entityData.get(GLOWING);
    }

    public void setAppliesGlowing() {
        this.entityData.set(GLOWING, (Object)true);
    }

    public int getLuck() {
        return (Integer)this.entityData.get(LUCK);
    }

    public void setLuck(int luck) {
        this.entityData.set(LUCK, (Object)luck);
    }

    public int getBleeding() {
        return (Integer)this.entityData.get(BLEEDING);
    }

    public void setBleeding(int bleeding) {
        this.entityData.set(BLEEDING, (Object)bleeding);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.getBoolean("Bane")) {
            this.setBane();
        }
        if (compound.getBoolean("Ender")) {
            this.setEnder();
        }
        if (compound.getBoolean("AppliesGlowing")) {
            this.setAppliesGlowing();
        }
        if (compound.getBoolean("Speedy")) {
            this.setSpeedy();
        }
        this.setLuck(compound.getInt("Luck"));
        this.setBleeding(compound.getInt("Bleeding"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.isBane()) {
            compound.putBoolean("Bane", true);
        }
        if (this.isEnder()) {
            compound.putBoolean("Ender", true);
        }
        if (this.appliesGlowing()) {
            compound.putBoolean("AppliesGlowing", true);
        }
        if (this.isSpeedy()) {
            compound.putBoolean("Speedy", true);
        }
        compound.putInt("Luck", this.getLuck());
        compound.putInt("Bleeding", this.getBleeding());
    }

    public void setEffectsFromItem(ItemStack stack) {
        if (stack.getItem() == Items.ARROW) {
            this.potion = Potions.EMPTY;
            this.effects.clear();
            this.entityData.set(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
        Creeper creeper;
        BaneModifierAttachment attachment;
        super.doPostHurtEffects(living);
        if (this.isEnder()) {
            ForceUtils.teleportRandomly(living);
        }
        if (this.appliesGlowing()) {
            living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
        }
        if (this.getBleeding() > 0) {
            MobUtil.addBleedingEffect(this.getBleeding(), living, this.getOwner());
        }
        if (this.isBane() && living instanceof Creeper && (attachment = (BaneModifierAttachment)(creeper = (Creeper)living).getData(ForceAttachments.BANE_MODIFIER)).canExplode()) {
            creeper.setSwellDir(-1);
            creeper.getEntityData().set(Creeper.DATA_IS_IGNITED, (Object)false);
            attachment.setExplodeAbility(false);
            creeper.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof SwellGoal);
            ForceCraft.LOGGER.debug("Added Bane to " + living.getName());
            creeper.setData(ForceAttachments.BANE_MODIFIER, (Object)attachment);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)ForceRegistry.FORCE_ARROW.get());
    }

    public EntityType<?> getType() {
        return ForceEntities.FORCE_ARROW.get();
    }
}

