/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.banemodifier.BaneModifierAttachment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class BaneHandler {
    @SubscribeEvent
    public void onEnderTeleportEvent(EntityTeleportEvent.EnderEntity event) {
        BaneModifierAttachment attachment;
        EnderMan enderman;
        Entity entity = event.getEntity();
        if (entity instanceof EnderMan && (enderman = (EnderMan)entity).hasData(ForceAttachments.BANE_MODIFIER) && !(attachment = (BaneModifierAttachment)enderman.getData(ForceAttachments.BANE_MODIFIER)).canTeleport()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityCreation(EntityJoinLevelEvent event) {
        BaneModifierAttachment attachment;
        Creeper creeper;
        Entity entity;
        if (!event.getLevel().isClientSide() && (entity = event.getEntity()) instanceof Creeper && (creeper = (Creeper)entity).hasData(ForceAttachments.BANE_MODIFIER) && !(attachment = (BaneModifierAttachment)creeper.getData(ForceAttachments.BANE_MODIFIER)).canExplode()) {
            creeper.setSwellDir(-1);
            creeper.getEntityData().set(Creeper.DATA_IS_IGNITED, (Object)false);
            attachment.setExplodeAbility(false);
            creeper.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof SwellGoal);
            creeper.setData(ForceAttachments.BANE_MODIFIER, (Object)attachment);
        }
    }
}

