/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.playermodifier.PlayerModifierAttachment;
import com.mrbysco.forcecraft.attachment.toolmodifier.ToolModifierAttachment;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LootingLevelEvent;

public class LootingHandler {
    @SubscribeEvent
    public void onLooting(LootingLevelEvent event) {
        Entity entity;
        DamageSource source = event.getDamageSource();
        if (source == null || source.getEntity() == null) {
            return;
        }
        int level = event.getLootingLevel();
        int customLevel = 0;
        if (source.getEntity().hasData(ForceAttachments.PLAYER_MOD)) {
            customLevel += ((PlayerModifierAttachment)source.getEntity().getData(ForceAttachments.PLAYER_MOD)).getLuckLevel();
        }
        if ((entity = source.getDirectEntity()) instanceof ForceArrowEntity) {
            ForceArrowEntity forceArrow = (ForceArrowEntity)entity;
            customLevel += forceArrow.getLuck();
        }
        if (customLevel > 4) {
            customLevel = 4;
        }
        event.setLootingLevel(level += customLevel);
    }

    @SubscribeEvent
    public void onTreasureDrop(LivingDropsEvent event) {
        ToolModifierAttachment attachment;
        Player player;
        ItemStack heldStack;
        if (event.getSource() == null || event.getSource().getEntity() == null) {
            return;
        }
        Entity source = event.getSource().getEntity();
        if (source instanceof Player && (heldStack = (player = (Player)source).getMainHandItem()).hasData(ForceAttachments.TOOL_MODIFIER) && (attachment = (ToolModifierAttachment)heldStack.getData(ForceAttachments.TOOL_MODIFIER)).hasTreasure()) {
            float dropChance;
            RandomSource rand = player.getRandom();
            int looting = event.getLootingLevel();
            LivingEntity entity = event.getEntity();
            BlockPos entityPos = entity.blockPosition();
            int chanceMax = 20;
            if (looting > 0 && (chanceMax /= looting) < 0) {
                chanceMax = 1;
            }
            if ((dropChance = (float)rand.nextInt(chanceMax)) == 0.0f) {
                if (entity.isInvertedHealAndHarm()) {
                    event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), new ItemStack((ItemLike)ForceRegistry.UNDEATH_CARD.get(), rand.nextInt(Math.max(1, looting)) + 1)));
                } else if (entity instanceof Monster) {
                    event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), new ItemStack((ItemLike)ForceRegistry.DARKNESS_CARD.get(), rand.nextInt(Math.max(1, looting)) + 1)));
                } else {
                    event.getDrops().add(new ItemEntity(entity.level(), (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), new ItemStack((ItemLike)ForceRegistry.LIFE_CARD.get(), rand.nextInt(Math.max(1, looting)) + 1)));
                }
            }
        }
    }
}

