/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.playermodifier.PlayerModifierAttachment;
import com.mrbysco.forcecraft.attachment.toolmodifier.ToolModifierAttachment;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerCapHandler {
    private static final int SPEED_DURATION = 200;

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.level().isClientSide) {
            Player player = event.player;
            Iterable armor = player.getArmorSlots();
            int speed = 0;
            for (ItemStack slotSelected : armor) {
                if (!(slotSelected.getItem() instanceof ForceArmorItem)) continue;
                ToolModifierAttachment attachment = (ToolModifierAttachment)slotSelected.getData(ForceAttachments.TOOL_MODIFIER);
                speed += attachment.getSpeedLevel();
            }
            if (speed > 0) {
                MobEffectInstance speedEffect = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, speed - 1, false, false);
                if (!player.hasEffect(MobEffects.MOVEMENT_SPEED) || player.hasEffect(MobEffects.MOVEMENT_SPEED) && player.getEffect(MobEffects.MOVEMENT_SPEED).getDuration() <= 100) {
                    player.addEffect(speedEffect);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerCapHandler.updateArmorProperties(event.getEntity());
    }

    @SubscribeEvent
    public void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerCapHandler.updateArmorProperties(player);
        }
    }

    public static void updateArmorProperties(Player player) {
        Iterable armor = player.getArmorSlots();
        int armorPieces = 0;
        int damage = 0;
        int heat = 0;
        int luck = 0;
        int bane = 0;
        int bleed = 0;
        for (ItemStack slotSelected : armor) {
            if (!(slotSelected.getItem() instanceof ForceArmorItem)) continue;
            ToolModifierAttachment attachment = (ToolModifierAttachment)slotSelected.getData(ForceAttachments.TOOL_MODIFIER);
            ++armorPieces;
            damage += (int)((double)attachment.getSharpLevel() * (Double)ConfigHandler.COMMON.forcePunchDamage.get());
            if (attachment.hasHeat()) {
                ++heat;
            }
            if (attachment.hasLuck()) {
                ++luck;
            }
            if (attachment.hasBane()) {
                ++bane;
            }
            if (!attachment.hasBleed()) continue;
            bleed += attachment.getBleedLevel();
        }
        PlayerModifierAttachment attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD);
        int finalArmorPieces = armorPieces;
        attachment.setArmorPieces(finalArmorPieces);
        int finalDamage = damage;
        attachment.setAttackDamage(1.0f * (float)finalDamage);
        int finalHeat = heat;
        attachment.setHeatPieces(finalHeat);
        attachment.setHeatDamage(2.0f * (float)finalHeat);
        int finalLuck = luck;
        attachment.setLuckLevel(finalLuck);
        int finalBane = bane;
        attachment.setBane(finalBane > 0);
        int finalBleed = bleed;
        attachment.setBleeding(finalBleed);
        player.setData(ForceAttachments.PLAYER_MOD, (Object)attachment);
    }

    @SubscribeEvent
    public void harvestCheckEvent(PlayerEvent.HarvestCheck event) {
        PlayerModifierAttachment attachment;
        Player player = event.getEntity();
        if (player.hasData(ForceAttachments.PLAYER_MOD) && (attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD)).hasFullSet() && player.getMainHandItem().isEmpty() && event.getTargetBlock().getBlock().getExplosionResistance() <= 2.0f) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        PlayerModifierAttachment attachment;
        Player player = event.getEntity();
        if (player.hasData(ForceAttachments.PLAYER_MOD) && (attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD)).hasFullSet() && player.getMainHandItem().isEmpty() && event.getOriginalSpeed() < 6.0f) {
            event.setNewSpeed(6.0f);
        }
    }
}

