/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.banemodifier.BaneModifierAttachment;
import com.mrbysco.forcecraft.attachment.playermodifier.PlayerModifierAttachment;
import com.mrbysco.forcecraft.attachment.toolmodifier.ToolModifierAttachment;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.util.MobUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ToolModifierHandler {
    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        Player player;
        if (event.getSource() == null) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        Entity trueSource = source.getEntity();
        if (trueSource instanceof Player) {
            INBTSerializable<CompoundTag> attachment;
            player = (Player)source.getEntity();
            boolean appliedBane = false;
            int bleedLevel = 0;
            if (player.getMainHandItem().hasData(ForceAttachments.TOOL_MODIFIER)) {
                attachment = (ToolModifierAttachment)player.getMainHandItem().getData(ForceAttachments.TOOL_MODIFIER);
                if (attachment.hasBane()) {
                    this.applyBane(target);
                    appliedBane = true;
                }
                if (attachment.hasBleed()) {
                    bleedLevel = attachment.getBleedLevel();
                }
            }
            MobUtil.addBleedingEffect(bleedLevel, target, (Entity)player);
            if (player.hasData(ForceAttachments.PLAYER_MOD)) {
                attachment = (PlayerModifierAttachment)player.getData(ForceAttachments.PLAYER_MOD);
                if (attachment.hasBane() && !appliedBane) {
                    this.applyBane(target);
                }
                float damage = event.getAmount();
                if (attachment.hasHeatDamage()) {
                    damage = attachment.getAttackDamage() == 0.0f ? (damage += attachment.getHeatDamage()) : (damage += attachment.getAttackDamage());
                    target.setRemainingFireTicks(30 * attachment.getHeatPieces());
                } else {
                    damage += attachment.getAttackDamage();
                }
                if (attachment.getAttackDamage() > 0.0f && player.getMainHandItem().isEmpty()) {
                    player.level().playSound((Player)null, target.getX(), target.getY(), target.getZ(), (SoundEvent)ForceSounds.FORCE_PUNCH.get(), player.getSoundSource(), 1.0f, 1.0f);
                    event.setAmount(damage);
                }
            }
        }
        if (target instanceof Player) {
            player = (Player)target;
            int sturdyLevel = 0;
            for (ItemStack armorStack : player.getArmorSlots()) {
                if (!armorStack.hasData(ForceAttachments.TOOL_MODIFIER) || !((ToolModifierAttachment)armorStack.getData(ForceAttachments.TOOL_MODIFIER)).hasSturdy()) continue;
                ++sturdyLevel;
            }
            if (sturdyLevel > 0) {
                double perArmor = (Double)ConfigHandler.COMMON.sturdyDamageReduction.get();
                double percentage = (double)sturdyLevel * (perArmor / 4.0);
                float oldDamage = event.getAmount();
                float newDamage = (float)((double)oldDamage - (double)oldDamage * percentage);
                event.setAmount(Mth.clamp((float)newDamage, (float)1.0f, (float)Float.MAX_VALUE));
            }
        }
    }

    private void applyBane(LivingEntity target) {
        EnderMan enderman;
        Creeper creeper;
        BaneModifierAttachment attachment;
        if (target instanceof Creeper && (attachment = (BaneModifierAttachment)(creeper = (Creeper)target).getData(ForceAttachments.BANE_MODIFIER)).canExplode()) {
            creeper.setSwellDir(-1);
            creeper.getEntityData().set(Creeper.DATA_IS_IGNITED, (Object)false);
            attachment.setExplodeAbility(false);
            creeper.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof SwellGoal);
            creeper.setData(ForceAttachments.BANE_MODIFIER, (Object)attachment);
        }
        if (target instanceof EnderMan && (attachment = (BaneModifierAttachment)(enderman = (EnderMan)target).getData(ForceAttachments.BANE_MODIFIER)).canTeleport()) {
            attachment.setTeleportAbility(false);
            enderman.setData(ForceAttachments.BANE_MODIFIER, (Object)attachment);
        }
    }
}

