/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.items.FortuneItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CustomFoodItem
extends Item {
    public CustomFoodItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (this.isEdible()) {
            Item item = stack.getItem();
            ItemStack returnStack = entityLiving.eat(level, stack);
            if (!level.isClientSide && entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                if (item == ForceRegistry.FORTUNE_COOKIE.get()) {
                    ItemStack fortuneItem = new ItemStack((ItemLike)ForceRegistry.FORTUNE.get());
                    FortuneItem.addMessage(fortuneItem, new CompoundTag());
                    return fortuneItem;
                }
                if (item == ForceRegistry.SOUL_WAFER.get()) {
                    this.randPotionEffect((LivingEntity)player);
                }
            }
            return returnStack;
        }
        return stack;
    }

    public void randPotionEffect(LivingEntity entityLiving) {
        Random rnd = new Random();
        int rand = rnd.nextInt(16);
        Player player = (Player)entityLiving;
        switch (rand) {
            default: {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1000, 0, false, false));
                break;
            }
            case 1: {
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 1000, 0, false, false));
                break;
            }
            case 2: {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1000, 0, false, false));
                break;
            }
            case 3: {
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, 1000, 0, false, false));
                break;
            }
            case 4: {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1000, 0, false, false));
                break;
            }
            case 5: {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000, 0, false, false));
                break;
            }
            case 6: {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1000, 0, false, false));
                break;
            }
            case 7: {
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 1000, 0, false, false));
                break;
            }
            case 8: {
                player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 1000, 0, false, false));
                break;
            }
            case 9: {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 1000, 0, false, false));
                break;
            }
            case 10: {
                player.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 1000, 0, false, false));
                break;
            }
            case 11: {
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 1000, 0, false, false));
                break;
            }
            case 12: {
                player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 1000, 0, false, false));
                break;
            }
            case 13: {
                player.addEffect(new MobEffectInstance(MobEffects.GLOWING, 1000, 0, false, false));
                break;
            }
            case 14: {
                player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 1000, 0, false, false));
                break;
            }
            case 15: {
                player.addEffect(new MobEffectInstance(MobEffects.LUCK, 1000, 0, false, false));
            }
        }
    }
}

