/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.attachment.storage.PackStackHandler;
import com.mrbysco.forcecraft.attachment.storage.PackStorage;
import com.mrbysco.forcecraft.attachment.storage.StorageManager;
import com.mrbysco.forcecraft.client.gui.pack.RenameAndRecolorScreen;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.ForcePackMenu;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ForcePackItem
extends BaseItem {
    public static final String SLOTS_TOTAL = "SlotsTotal";
    public static final String SLOTS_USED = "SlotsUsed";

    public ForcePackItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            if (level.isClientSide) {
                RenameAndRecolorScreen.openScreen(stack, handIn);
            }
        } else if (!level.isClientSide) {
            PackStorage data = StorageManager.getOrCreatePack(stack);
            playerIn.openMenu(Objects.requireNonNull(this.getContainer(stack, data.getInventory())), buf -> buf.writeInt(data.getInventory().getUpgrades()));
        }
        return super.use(level, playerIn, handIn);
    }

    @Nullable
    public MenuProvider getContainer(ItemStack stack, PackStackHandler handler) {
        return new SimpleMenuProvider((id, playerInv, player) -> new ForcePackMenu(id, playerInv, handler), (Component)(stack.hasCustomHoverName() ? ((MutableComponent)stack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.pack")));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains(SLOTS_USED) && tag.contains(SLOTS_TOTAL)) {
            tooltip.add((Component)Component.literal((String)String.format("%s/%s Slots", tag.getInt(SLOTS_USED), tag.getInt(SLOTS_TOTAL))));
        } else {
            tooltip.add((Component)Component.literal((String)"0/8 Slots"));
        }
        if (flagIn.isAdvanced() && stack.getTag() != null && stack.getTag().contains("uuid")) {
            UUID uuid = stack.getTag().getUUID("uuid");
            tooltip.add((Component)Component.literal((String)("ID: " + uuid.toString().substring(0, 8))).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        super.appendHoverText(stack, level, tooltip, flagIn);
    }

    public Component getName(ItemStack stack) {
        return ((MutableComponent)super.getName(stack)).withStyle(ChatFormatting.YELLOW);
    }
}

