/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.BaseItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FortuneItem
extends BaseItem {
    private static final Random random = new Random();

    public FortuneItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        CompoundTag tag;
        ItemStack stack = playerIn.getItemInHand(handIn);
        CompoundTag compoundTag = tag = stack.hasTag() ? stack.getTag() : new CompoundTag();
        if (!tag.contains("message")) {
            FortuneItem.addMessage(stack, tag);
        }
        if (!level.isClientSide) {
            if (playerIn != null && playerIn.isShiftKeyDown()) {
                ItemStack paperStack;
                if (!playerIn.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                if (!playerIn.addItem(paperStack = new ItemStack((ItemLike)Items.PAPER))) {
                    playerIn.spawnAtLocation(paperStack);
                }
            } else {
                playerIn.sendSystemMessage((Component)Component.literal((String)tag.getString("message")));
            }
        }
        return super.use(level, playerIn, handIn);
    }

    public static void addMessage(ItemStack stack, CompoundTag tag) {
        ArrayList messages = new ArrayList((Collection)ConfigHandler.COMMON.fortuneMessages.get());
        String message = "No fortune for you";
        if (!messages.isEmpty()) {
            int idx = random.nextInt(messages.size());
            message = (String)messages.get(idx);
        }
        tag.putString("message", message);
        stack.setTag(tag);
    }
}

