/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.SpoilsBagMenu;
import com.mrbysco.forcecraft.registry.ForceTables;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SpoilsBagItem
extends BaseItem {
    private final int tier;

    public SpoilsBagItem(Item.Properties properties, int tier) {
        super(properties.stacksTo(1));
        this.tier = tier;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        this.populateBag(level, stack);
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        IItemHandler blockInventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face);
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null && blockInventory != null && blockInventory != null && handler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)handler;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack bagStack = itemHandler.getStackInSlot(i);
                ItemStack remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)bagStack, (int)bagStack.getCount());
                if (bagStack.isEmpty()) continue;
                remaining = ItemHandlerHelper.insertItem((IItemHandler)blockInventory, (ItemStack)bagStack, (boolean)false);
                itemHandler.setStackInSlot(i, remaining);
            }
            if (ItemHandlerUtils.isEmpty((IItemHandler)itemHandler)) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null) {
            this.populateBag(level, stack);
            playerIn.openMenu(this.getContainer(stack));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        return super.use(level, playerIn, handIn);
    }

    public ResourceLocation getTable() {
        return switch (this.tier) {
            default -> ForceTables.TIER_1;
            case 2 -> ForceTables.TIER_2;
            case 3 -> ForceTables.TIER_3;
        };
    }

    public void populateBag(Level level, ItemStack stack) {
        IItemHandler handler;
        if (!level.isClientSide && !stack.getOrCreateTag().getBoolean("Filled") && (handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM)) instanceof ItemStackHandler && ItemHandlerUtils.isEmpty(handler)) {
            ObjectArrayList lootStacks;
            CompoundTag tag = stack.getOrCreateTag();
            Object stacks = new ArrayList();
            do {
                LootParams.Builder lootParams;
                LootTable table;
                if ((lootStacks = (table = level.getServer().getLootData().getLootTable(this.getTable())).getRandomItems((lootParams = new LootParams.Builder((ServerLevel)level)).create(LootContextParamSets.EMPTY))).isEmpty()) {
                    return;
                }
                Collections.shuffle(lootStacks);
            } while ((stacks = lootStacks).isEmpty());
            if (stacks.size() > 7) {
                int newSize = Math.min(8, Math.max(5, level.random.nextInt(stacks.size())));
                if (stacks.size() < newSize) {
                    newSize = stacks.size();
                }
                ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
                for (int i = 0; i < newSize; ++i) {
                    newStacks.add((ItemStack)stacks.get(i));
                }
                stacks = newStacks;
            }
            ItemStackHandler stackhandler = (ItemStackHandler)handler;
            for (int i = 0; i < stacks.size(); ++i) {
                stackhandler.setStackInSlot(i, (ItemStack)stacks.get(i));
            }
            tag.putBoolean("Filled", true);
            stack.setTag(tag);
        }
    }

    @Nullable
    public MenuProvider getContainer(ItemStack stack) {
        return new SimpleMenuProvider((id, inventory, player) -> new SpoilsBagMenu(id, inventory, stack), (Component)(stack.hasCustomHoverName() ? ((MutableComponent)stack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.spoils_bag")));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        IItemHandler handler;
        if (!level.isClientSide && stack.hasTag() && stack.getTag().getBoolean("Filled") && ItemHandlerUtils.isEmpty(handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM))) {
            stack.shrink(1);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, level, tooltip, flagIn);
        tooltip.add((Component)Component.literal((String)("Tier: " + this.tier)).withStyle(ChatFormatting.GRAY));
    }
}

