/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.flask.MilkFlaskItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ForceFlaskItem
extends BaseItem {
    public ForceFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                FlaskEntity flaskEntity = new FlaskEntity(level, (LivingEntity)playerIn);
                flaskEntity.setItem(new ItemStack((ItemLike)ForceRegistry.ENTITY_FLASK.get()));
                flaskEntity.shootFromRotation((Entity)playerIn, playerIn.xRotO, playerIn.getYRot(), -20.0f, 0.5f, 1.0f);
                level.addFreshEntity((Entity)flaskEntity);
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!playerIn.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        Level level = entity.level();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        if (entity instanceof Cow && !entity.isBaby()) {
            playerIn.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            ItemStack milkStack = ((MilkFlaskItem)((Object)ForceRegistry.MILK_FORCE_FLASK.get())).getDefaultInstance();
            if (!playerIn.getInventory().add(milkStack)) {
                playerIn.spawnAtLocation(milkStack, 0.0f);
            }
            if (!playerIn.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, playerIn, entity, hand);
    }
}

