/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ForceToolData {
    private int force = 0;

    public int getForce() {
        return this.force;
    }

    public void setForce(int force) {
        this.force = force;
    }

    public ForceToolData(ItemStack tool) {
        CompoundTag tag = tool.getTag();
        if (tag != null && tag.contains("force")) {
            this.read(tool, tag);
        }
    }

    private void read(ItemStack tool, CompoundTag tag) {
        this.force = tag.getInt("force");
    }

    public CompoundTag write(ItemStack tool) {
        CompoundTag tag = tool.getOrCreateTag();
        tag.putInt("force", this.force);
        return tag;
    }

    public void charge(int incoming) {
        this.force += incoming;
    }

    public void attachInformation(List<Component> tooltip) {
        if (this.force > 0) {
            MutableComponent t = Component.translatable((String)"item.infuser.tooltip.forcelevel");
            t.append("" + this.force);
            t.withStyle(ChatFormatting.GOLD);
            tooltip.add((Component)t);
        }
    }
}

