/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class UpgradeBookData {
    private UpgradeBookTier tier = UpgradeBookTier.ZERO;
    private final Map<Integer, Set<ResourceLocation>> recipesUsed = new HashMap<Integer, Set<ResourceLocation>>();
    private int points = 0;
    private String progressCache = "";

    public UpgradeBookData(ItemStack book) {
        if (book.getItem() != ForceRegistry.UPGRADE_TOME.get()) {
            ForceCraft.LOGGER.error("invalid book data entering book {}", (Object)book);
            return;
        }
        CompoundTag tag = book.getTag();
        if (tag != null && tag.contains("tier")) {
            this.read(book, tag);
        } else {
            this.updateCache();
            this.write(book);
        }
    }

    public int nextTier() {
        if (this.getTier() == UpgradeBookTier.FINAL) {
            return 0;
        }
        return Math.max(0, this.getTier().pointsForLevelup() - this.points);
    }

    public void onRecipeApply(RecipeHolder<InfuseRecipe> recipeHolder, ItemStack bookStack) {
        Integer tier = ((InfuseRecipe)recipeHolder.value()).getTier().ordinal();
        Set<ResourceLocation> tierSet = new HashSet<ResourceLocation>();
        if (this.recipesUsed.containsKey(tier)) {
            tierSet = this.recipesUsed.get(tier);
        }
        tierSet.add(recipeHolder.id());
        this.recipesUsed.put(tier, tierSet);
        this.tryLevelUp();
        this.write(bookStack);
    }

    public void incrementPoints(int incoming) {
        this.points += incoming;
        this.tryLevelUp();
    }

    private void tryLevelUp() {
        if (this.canLevelUp()) {
            this.points -= this.getTier().pointsForLevelup();
            this.setTier(this.getTier().incrementTier());
            this.updateCache();
        }
    }

    private void updateCache() {
        int recipesThisTier;
        Set<ResourceLocation> thisTier = this.recipesUsed.get(this.tier.ordinal());
        int n = recipesThisTier = thisTier == null ? 0 : thisTier.size();
        if (!InfuserBlockEntity.LEVEL_RECIPE_LIST.isEmpty()) {
            int totalThisTier = InfuserBlockEntity.LEVEL_RECIPE_LIST.get(this.tier.ordinal()).size();
            this.progressCache = recipesThisTier + "/" + totalThisTier;
        }
    }

    private boolean canLevelUp() {
        Set<ResourceLocation> thisTier = this.recipesUsed.get(this.tier.ordinal());
        int recipesThisTier = thisTier == null ? 0 : thisTier.size();
        int totalThisTier = InfuserBlockEntity.LEVEL_RECIPE_LIST.get(this.tier.ordinal()).size();
        this.updateCache();
        if (this.points < this.getTier().pointsForLevelup() || this.getTier() == UpgradeBookTier.FINAL) {
            return false;
        }
        return recipesThisTier >= totalThisTier;
    }

    private void read(ItemStack book, CompoundTag tag) {
        this.progressCache = tag.getString("progressCache");
        this.setTier(UpgradeBookTier.values()[tag.getInt("tier")]);
        this.points = tag.getInt("points");
        for (UpgradeBookTier tier : UpgradeBookTier.values()) {
            HashSet<ResourceLocation> tierSet = new HashSet<ResourceLocation>();
            ListTag listTag = (ListTag)tag.get("tier" + tier.ordinal());
            if (listTag != null) {
                for (Tag value : listTag) {
                    CompoundTag tg = (CompoundTag)value;
                    String id = tg.getString("id");
                    if (id.isEmpty() || "minecraft:".equalsIgnoreCase(id)) continue;
                    tierSet.add(ResourceLocation.tryParse((String)id));
                }
            }
            this.recipesUsed.put(tier.ordinal(), tierSet);
        }
    }

    public CompoundTag write(ItemStack bookInSlot) {
        CompoundTag tag = bookInSlot.getOrCreateTag();
        tag.putString("progressCache", this.progressCache);
        tag.putInt("tier", this.getTier().ordinal());
        tag.putInt("points", this.points);
        for (UpgradeBookTier tier : UpgradeBookTier.values()) {
            Set<ResourceLocation> tierSet = this.recipesUsed.get(tier.ordinal());
            if (tierSet == null) {
                tierSet = new HashSet<ResourceLocation>();
            }
            ListTag listTag = new ListTag();
            for (ResourceLocation id : tierSet) {
                if ("minecraft:".equalsIgnoreCase(id.toString())) continue;
                CompoundTag tg = new CompoundTag();
                tg.putString("id", id.toString());
                listTag.add((Object)tg);
            }
            tag.put("tier" + tier.ordinal(), (Tag)listTag);
        }
        return tag;
    }

    public String getProgressCache() {
        return this.progressCache;
    }

    public UpgradeBookTier getTier() {
        return this.tier;
    }

    public void setTier(UpgradeBookTier tier) {
        this.tier = tier;
    }

    public int getPoints() {
        return this.points;
    }
}

