/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.toolmodifier.ToolModifierAttachment;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ForceArrowItem
extends ArrowItem {
    public ForceArrowItem(Item.Properties builder) {
        super(builder);
    }

    public AbstractArrow createArrow(Level level, ItemStack stack, LivingEntity shooter) {
        Player player;
        ItemStack heldItem;
        ForceArrowEntity forceArrow = new ForceArrowEntity(level, shooter);
        if (shooter instanceof Player && (heldItem = (player = (Player)shooter).getUseItem()).getItem() instanceof ForceBowItem) {
            ToolModifierAttachment attachment = (ToolModifierAttachment)heldItem.getData(ForceAttachments.TOOL_MODIFIER);
            if (attachment.hasFreezing()) {
                forceArrow.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2, false, false));
            }
            if (attachment.hasEnder()) {
                forceArrow.setEnder();
            }
            if (attachment.hasBane()) {
                forceArrow.setBane();
            }
            if (attachment.hasLight()) {
                forceArrow.setAppliesGlowing();
            }
            if (attachment.hasBleed()) {
                forceArrow.setBleeding(attachment.getBleedLevel());
            }
            if (attachment.hasLuck()) {
                int luckValue = attachment.getLuckLevel();
                forceArrow.setLuck(luckValue);
            }
            if (attachment.getSpeedLevel() > 0) {
                forceArrow.setSpeedy();
            }
        }
        forceArrow.setEffectsFromItem(stack);
        return forceArrow;
    }
}

