/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.attachment.toolmodifier.ToolModifierAttachment;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.items.tools.ForceArrowItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class ForceBowItem
extends BowItem
implements IForceChargingTool {
    public static final Predicate<ItemStack> FORCE_ARROWS = stack -> stack.getItem() instanceof ForceArrowItem;

    public ForceBowItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(332));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerentity = (Player)entityLiving;
            boolean flag = playerentity.getAbilities().instabuild || EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.getProjectile(stack);
            int i = this.getUseDuration(stack) - timeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)playerentity, (int)i, (!itemstack.isEmpty() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.isEmpty() || flag) {
                float f;
                if (itemstack.isEmpty()) {
                    itemstack = new ItemStack((ItemLike)ForceRegistry.FORCE_ARROW.get());
                }
                if (!((double)(f = ForceBowItem.getPowerForTime((int)i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = playerentity.getAbilities().instabuild || itemstack.getItem() instanceof ForceArrowItem && ((ForceArrowItem)itemstack.getItem()).isInfinite(itemstack, stack, playerentity);
                    if (!level.isClientSide) {
                        int k;
                        int j;
                        ForceArrowItem arrowitem = (ForceArrowItem)(itemstack.getItem() instanceof ForceArrowItem ? itemstack.getItem() : (Item)ForceRegistry.FORCE_ARROW.get());
                        AbstractArrow abstractarrowentity = arrowitem.createArrow(level, itemstack, (LivingEntity)playerentity);
                        abstractarrowentity = this.customArrow(abstractarrowentity, itemstack);
                        abstractarrowentity.shootFromRotation((Entity)playerentity, playerentity.getXRot(), playerentity.getYRot(), 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            abstractarrowentity.setCritArrow(true);
                        }
                        if ((j = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack)) > 0) {
                            abstractarrowentity.setBaseDamage(abstractarrowentity.getBaseDamage() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (ItemStack)stack)) > 0) {
                            abstractarrowentity.setKnockback(k);
                        }
                        if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)stack) > 0) {
                            abstractarrowentity.setSecondsOnFire(100);
                        }
                        stack.hurtAndBreak(1, (LivingEntity)playerentity, player -> player.broadcastBreakEvent(playerentity.getUsedItemHand()));
                        if (flag1 || playerentity.getAbilities().instabuild && (itemstack.getItem() == Items.SPECTRAL_ARROW || itemstack.getItem() == Items.TIPPED_ARROW)) {
                            abstractarrowentity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)abstractarrowentity);
                    }
                    level.playSound((Player)null, playerentity.getX(), playerentity.getY(), playerentity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (playerentity.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !playerentity.getAbilities().instabuild) {
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            playerentity.getInventory().removeItem(itemstack);
                        }
                    }
                    playerentity.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModifierAttachment.attachInformation(stack, lores);
        super.appendHoverText(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return FORCE_ARROWS;
    }
}

