/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ToolActions;

public class ForceMittItem
extends DiggerItem {
    private final float attackDamage;
    private final Tier itemTier = ModToolTiers.FORCE;

    public ForceMittItem(Item.Properties properties) {
        super(8.0f, 8.0f, ModToolTiers.FORCE, ForceTags.MINEABLE_WITH_MITTS, properties.durability(1000));
        this.attackDamage = 3.0f;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (state.is(BlockTags.LEAVES)) {
                BlockHitResult traceResult = ForceMittItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                switch (traceResult.getDirection().getAxis()) {
                    case X: {
                        this.breakBlockAt(player, level, stack, pos.above());
                        this.breakBlockAt(player, level, stack, pos.below());
                        this.breakBlockAt(player, level, stack, pos.north());
                        this.breakBlockAt(player, level, stack, pos.north().above());
                        this.breakBlockAt(player, level, stack, pos.north().below());
                        this.breakBlockAt(player, level, stack, pos.south());
                        this.breakBlockAt(player, level, stack, pos.south().above());
                        this.breakBlockAt(player, level, stack, pos.south().below());
                        break;
                    }
                    case Z: {
                        this.breakBlockAt(player, level, stack, pos.above());
                        this.breakBlockAt(player, level, stack, pos.below());
                        this.breakBlockAt(player, level, stack, pos.west());
                        this.breakBlockAt(player, level, stack, pos.west().above());
                        this.breakBlockAt(player, level, stack, pos.west().below());
                        this.breakBlockAt(player, level, stack, pos.east());
                        this.breakBlockAt(player, level, stack, pos.east().above());
                        this.breakBlockAt(player, level, stack, pos.east().below());
                        break;
                    }
                    case Y: {
                        this.breakBlockAt(player, level, stack, pos.north());
                        this.breakBlockAt(player, level, stack, pos.east());
                        this.breakBlockAt(player, level, stack, pos.west());
                        this.breakBlockAt(player, level, stack, pos.west().north());
                        this.breakBlockAt(player, level, stack, pos.west().east());
                        this.breakBlockAt(player, level, stack, pos.east());
                        this.breakBlockAt(player, level, stack, pos.east().north());
                        this.breakBlockAt(player, level, stack, pos.east().east());
                    }
                }
                level.playSound((Player)null, pos, (SoundEvent)ForceSounds.WHOOSH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.mineBlock(stack, level, state, pos, entityLiving);
    }

    public void breakBlockAt(Player player, Level level, ItemStack stack, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (level.getBlockState(pos).is(BlockTags.LEAVES)) {
            BlockState state = level.getBlockState(pos);
            if (!CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
                return;
            }
            if (!level.isClientSide) {
                int xp = CommonHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
                if (xp == -1) {
                    return;
                }
                FluidState fluidState = level.getFluidState(pos);
                Block block = state.getBlock();
                if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                    block.playerWillDestroy(level, pos, state, player);
                    block.playerDestroy(level, player, pos, state, tileEntity, stack);
                    block.popExperience((ServerLevel)level, pos, xp);
                }
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
        }
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        Pair pair = (Pair)HoeItem.TILLABLES.get(level.getBlockState(blockpos).getBlock());
        if (context.getClickedFace() != Direction.DOWN && level.isEmptyBlock(blockpos.above())) {
            if (pair == null) {
                return InteractionResult.PASS;
            }
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    consumer.accept(context);
                    if (player != null) {
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, p_150845_ -> p_150845_.broadcastBreakEvent(context.getHand()));
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.playSound(player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
            level.setBlock(blockpos, optional.get(), 11);
            if (player != null) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, player1 -> player1.broadcastBreakEvent(context.getHand()));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return state.is(this.blocks) ? 14.0f : 1.0f;
    }

    public float getAttackDamage() {
        return this.itemTier.getAttackDamageBonus();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, attackerEntity -> attackerEntity.broadcastBreakEvent(InteractionHand.MAIN_HAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot equipmentSlot) {
        Multimap multimap = super.getDefaultAttributeModifiers(equipmentSlot);
        if (equipmentSlot == EquipmentSlot.MAINHAND && multimap != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon damage modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon speed modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
            multimap = builder.build();
        }
        return multimap;
    }
}

