/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.forcerod.ForceRodAttachment;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.items.nonburnable.InertCoreItem;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ForceRodItem
extends BaseItem
implements IForceChargingTool {
    public List<Reference.MODIFIERS> applicableModifiers = new ArrayList<Reference.MODIFIERS>();

    public ForceRodItem(Item.Properties properties) {
        super(properties.durability(75));
        this.setApplicableModifiers();
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand handIn = context.getHand();
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide && player != null) {
            ForceRodAttachment attachment;
            if (level.getBlockState(pos).getBlock() instanceof FireBlock) {
                level.removeBlock(pos, false);
                list = level.getEntitiesOfClass(ItemEntity.class, new AABB(new BlockPos(pos.getX(), pos.getY(), pos.getZ())).expandTowards(0.5, 1.0, 0.5));
                boolean bw = false;
                for (ItemEntity itemEntity : list) {
                    if (itemEntity == null || !(itemEntity.getItem().getItem() instanceof InertCoreItem)) continue;
                    NonBurnableItemEntity bottledWither = new NonBurnableItemEntity(level, pos.getX(), pos.getY() + 1, pos.getZ(), new ItemStack((ItemLike)ForceRegistry.BOTTLED_WITHER.get(), itemEntity.getItem().getCount()));
                    level.addFreshEntity((Entity)bottledWither);
                    stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                    bw = true;
                }
                if (bw) {
                    for (ItemEntity itemEntity : list) {
                        if (itemEntity == null || !(itemEntity.getItem().getItem() instanceof InertCoreItem)) continue;
                        itemEntity.discard();
                    }
                }
            } else {
                list = level.getEntitiesOfClass(ItemEntity.class, new AABB(new BlockPos(pos.getX(), pos.getY(), pos.getZ())).expandTowards(0.5, 1.0, 0.5));
                for (ItemEntity itemEntity : list) {
                    if (itemEntity == null || !(itemEntity.getItem().getItem() instanceof ArmorItem)) continue;
                    if (((ArmorItem)itemEntity.getItem().getItem()).getEquipmentSlot() == EquipmentSlot.CHEST) {
                        if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.IRON) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.IRON_INGOT, 6)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        } else if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.GOLD) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.GOLD_INGOT, 6)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        } else if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.LEATHER) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ForceRegistry.FORCE_CHEST.get(), 1)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        }
                    }
                    if (((ArmorItem)itemEntity.getItem().getItem()).getEquipmentSlot() == EquipmentSlot.LEGS) {
                        if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.IRON) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.IRON_INGOT, 5)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        } else if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.GOLD) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.GOLD_INGOT, 5)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        } else if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.LEATHER) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ForceRegistry.FORCE_LEGS.get(), 1)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        }
                    }
                    if (((ArmorItem)itemEntity.getItem().getItem()).getEquipmentSlot() == EquipmentSlot.FEET) {
                        if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.IRON) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.IRON_INGOT, 3)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        } else if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.GOLD) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.GOLD_INGOT, 3)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        } else if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.LEATHER) {
                            itemEntity.discard();
                            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ForceRegistry.FORCE_BOOTS.get(), 1)));
                            stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        }
                    }
                    if (((ArmorItem)itemEntity.getItem().getItem()).getEquipmentSlot() != EquipmentSlot.HEAD) continue;
                    if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.IRON) {
                        itemEntity.discard();
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.IRON_INGOT, 4)));
                        stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        continue;
                    }
                    if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() == ArmorMaterials.GOLD) {
                        itemEntity.discard();
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)Items.GOLD_INGOT, 4)));
                        stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                        continue;
                    }
                    if (((ArmorItem)itemEntity.getItem().getItem()).getMaterial() != ArmorMaterials.LEATHER) continue;
                    itemEntity.discard();
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ForceRegistry.FORCE_HELMET.get(), 1)));
                    stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> playerIn.broadcastBreakEvent(handIn));
                }
            }
            if (stack.hasData(ForceAttachments.FORCE_ROD) && (attachment = (ForceRodAttachment)stack.getData(ForceAttachments.FORCE_ROD)).hasEnderModifier()) {
                if (player.isShiftKeyDown()) {
                    attachment.setHomeLocation(GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)player.blockPosition()));
                    stack.setData(ForceAttachments.FORCE_ROD, (Object)attachment);
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)Component.translatable((String)"forcecraft.ender_rod.location.set").withStyle(ChatFormatting.DARK_PURPLE), true);
                    }
                } else if (attachment.getHomeLocation() != null) {
                    attachment.teleportPlayerToLocation(player, attachment.getHomeLocation());
                    stack.hurtAndBreak(1, (LivingEntity)player, playerIn -> player.broadcastBreakEvent(handIn));
                    player.getCooldowns().addCooldown((Item)this, 10);
                    level.playSound((Player)null, player.xo, player.yo, player.zo, SoundEvents.ENDERMAN_TELEPORT, player.getSoundSource(), 1.0f, 1.0f);
                    player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn != null) {
            ForceRodAttachment attachment = (ForceRodAttachment)stack.getData(ForceAttachments.FORCE_ROD);
            if (attachment.getHealingLevel() > 0) {
                int healingLevel = attachment.getHealingLevel();
                playerIn.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, healingLevel - 1, false, false));
                stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
                playerIn.getCooldowns().addCooldown((Item)this, 10);
            }
            if (attachment.hasCamoModifier()) {
                playerIn.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 1000, 0, false, false));
                stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
                playerIn.getCooldowns().addCooldown((Item)this, 10);
            }
            if (attachment.hasEnderModifier()) {
                if (playerIn.isShiftKeyDown()) {
                    attachment.setHomeLocation(GlobalPos.of((ResourceKey)playerIn.level().dimension(), (BlockPos)playerIn.blockPosition()));
                } else if (attachment.getHomeLocation() != null) {
                    attachment.teleportPlayerToLocation(playerIn, attachment.getHomeLocation());
                    stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
                    playerIn.getCooldowns().addCooldown((Item)this, 10);
                    level.playSound((Player)null, playerIn.xo, playerIn.yo, playerIn.zo, SoundEvents.ENDERMAN_TELEPORT, playerIn.getSoundSource(), 1.0f, 1.0f);
                    playerIn.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            if (attachment.hasSightModifier()) {
                playerIn.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 1000, 0, false, false));
                stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
                playerIn.getCooldowns().addCooldown((Item)this, 10);
            }
            if (attachment.hasLight()) {
                playerIn.addEffect(new MobEffectInstance(MobEffects.GLOWING, 1000, 0, false, false));
                stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
                playerIn.getCooldowns().addCooldown((Item)this, 10);
            }
            if (attachment.getSpeedLevel() > 0) {
                playerIn.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, attachment.getSpeedLevel() - 1, false, false));
                stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
                playerIn.getCooldowns().addCooldown((Item)this, 10);
            }
            stack.setData(ForceAttachments.FORCE_ROD, (Object)attachment);
        }
        return super.use(level, playerIn, handIn);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand handIn) {
        ForceRodAttachment attachment;
        if (playerIn != null && (attachment = (ForceRodAttachment)stack.getData(ForceAttachments.FORCE_ROD)).hasLight()) {
            target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 2400, 0, false, false));
            stack.hurtAndBreak(1, (LivingEntity)playerIn, player -> player.broadcastBreakEvent(handIn));
            playerIn.getCooldowns().addCooldown((Item)this, 10);
        }
        return super.interactLivingEntity(stack, playerIn, target, handIn);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, level, entityIn, itemSlot, isSelected);
        if (stack.getTag() != null && !stack.getTag().contains("ForceInfused")) {
            this.initializeTag(stack);
        }
    }

    private void initializeTag(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putBoolean("ForceInfused", false);
        stack.setTag(tag);
    }

    public void setApplicableModifiers() {
        this.applicableModifiers.add(Reference.MODIFIERS.MOD_HEALING);
        this.applicableModifiers.add(Reference.MODIFIERS.MOD_ENDER);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ForceRodAttachment.attachInformation(stack, lores);
        super.appendHoverText(stack, level, lores, flagIn);
    }
}

