/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.toolmodifier.ToolModifierAttachment;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ForceShearsItem
extends ShearsItem
implements IForceChargingTool {
    private static final int SET_FIRE_TIME = 10;
    private static final int SHEARS_DMG = 238;
    private static final Item[] WOOL = new Item[]{Items.RED_WOOL, Items.BLUE_WOOL, Items.BLACK_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.WHITE_WOOL, Items.ORANGE_WOOL, Items.MAGENTA_WOOL, Items.LIGHT_BLUE_WOOL, Items.YELLOW_WOOL, Items.LIME_WOOL, Items.PINK_WOOL, Items.GRAY_WOOL, Items.LIGHT_GRAY_WOOL, Items.CYAN_WOOL, Items.PURPLE_WOOL, Items.BROWN_WOOL, Items.GREEN_WOOL};

    public ForceShearsItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(952));
    }

    private ItemStack getRandomWool(Level level) {
        return new ItemStack((ItemLike)WOOL[Mth.nextInt((RandomSource)level.random, (int)0, (int)WOOL.length)]);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        BlockPos pos;
        Sheep target;
        Level world = entity.level();
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        RandomSource rand = world.random;
        ToolModifierAttachment attachment = (ToolModifierAttachment)stack.getData(ForceAttachments.TOOL_MODIFIER);
        if (attachment.hasRainbow() && entity instanceof Sheep && (target = (Sheep)entity).isShearable(stack, world, pos = BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()))) {
            List drops = target.onSheared(playerIn, stack, world, pos, EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.BLOCK_FORTUNE, (ItemStack)stack));
            for (int i = 0; i < drops.size(); ++i) {
                ItemEntity ent = entity.spawnAtLocation(this.getRandomWool(world), 1.0f);
                if (ent == null) continue;
                ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            }
            stack.hurtAndBreak(1, entity, e -> e.broadcastBreakEvent(hand));
            return InteractionResult.SUCCESS;
        }
        boolean hasHeat = attachment.hasHeat();
        if (!(entity instanceof IColdMob)) {
            if (entity instanceof Cow) {
                Cow originalCow = (Cow)entity;
                if (!(entity instanceof MushroomCow)) {
                    int i = 1 + rand.nextInt(3);
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    for (int j = 0; j < i; ++j) {
                        drops.add(new ItemStack((ItemLike)Items.LEATHER, 1));
                    }
                    drops.forEach(d -> {
                        ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                        if (ent != null) {
                            ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                        }
                    });
                    entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
                    ColdCowEntity replacementMob = new ColdCowEntity(world, BuiltInRegistries.ENTITY_TYPE.getKey((Object)originalCow.getType()));
                    replacementMob.copyPosition((Entity)originalCow);
                    UUID mobUUID = replacementMob.getUUID();
                    replacementMob.restoreFrom((Entity)originalCow);
                    replacementMob.setUUID(mobUUID);
                    originalCow.remove(Entity.RemovalReason.DISCARDED);
                    world.addFreshEntity((Entity)replacementMob);
                    if (hasHeat) {
                        replacementMob.setSecondsOnFire(10);
                    }
                    stack.hurtAndBreak(1, entity, e -> e.broadcastBreakEvent(hand));
                    return InteractionResult.SUCCESS;
                }
            }
            if (entity instanceof Chicken) {
                Chicken originalChicken = (Chicken)entity;
                Level level = originalChicken.level();
                int i = 1 + rand.nextInt(3);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack((ItemLike)Items.FEATHER, 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
                entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
                ColdChickenEntity replacementMob = new ColdChickenEntity(level, BuiltInRegistries.ENTITY_TYPE.getKey((Object)originalChicken.getType()));
                replacementMob.copyPosition((Entity)originalChicken);
                UUID mobUUID = replacementMob.getUUID();
                replacementMob.restoreFrom((Entity)originalChicken);
                replacementMob.setUUID(mobUUID);
                originalChicken.remove(Entity.RemovalReason.DISCARDED);
                level.addFreshEntity((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.setSecondsOnFire(10);
                }
                stack.hurtAndBreak(1, entity, e -> e.broadcastBreakEvent(hand));
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof Pig) {
                Pig originalPig = (Pig)entity;
                Level level = originalPig.level();
                int i = 1 + rand.nextInt(2);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack(hasHeat ? (ItemLike)ForceRegistry.COOKED_BACON.get() : (ItemLike)ForceRegistry.RAW_BACON.get(), 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation(d, 1.0f);
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
                entity.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
                ColdPigEntity replacementMob = new ColdPigEntity(level, BuiltInRegistries.ENTITY_TYPE.getKey((Object)originalPig.getType()));
                replacementMob.copyPosition((Entity)originalPig);
                UUID mobUUID = replacementMob.getUUID();
                replacementMob.restoreFrom((Entity)originalPig);
                replacementMob.setUUID(mobUUID);
                originalPig.remove(Entity.RemovalReason.DISCARDED);
                level.addFreshEntity((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.setSecondsOnFire(10);
                }
                stack.hurtAndBreak(1, entity, e -> e.broadcastBreakEvent(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(stack, playerIn, entity, hand);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModifierAttachment.attachInformation(stack, lores);
        super.appendHoverText(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

