/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.magnet.MagnetAttachment;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceEffects;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class MagnetGloveItem
extends BaseItem {
    public MagnetGloveItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown()) {
            MagnetAttachment attachment;
            ItemStack stack = playerIn.getItemInHand(handIn);
            boolean state = (attachment = (MagnetAttachment)stack.getData(ForceAttachments.MAGNET)).isActivated();
            attachment.setActivation(!state);
            stack.setData(ForceAttachments.MAGNET, (Object)attachment);
            level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return super.use(level, playerIn, handIn);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        MagnetAttachment attachment;
        if (entityIn instanceof Player && !(entityIn instanceof FakePlayer) && itemSlot >= 0 && itemSlot <= Inventory.getSelectionSize() && (attachment = (MagnetAttachment)stack.getData(ForceAttachments.MAGNET)).isActivated()) {
            ((Player)entityIn).addEffect(new MobEffectInstance(ForceEffects.MAGNET.get(), 20, 1, true, false));
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        MagnetAttachment.attachInformation(stack, lores);
        super.appendHoverText(stack, level, lores, flagIn);
    }
}

