/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.items.SpoilsBagItem;
import com.mrbysco.forcecraft.registry.ForceMenus;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SpoilsBagMenu
extends AbstractContainerMenu {
    private ItemStack heldStack;

    public boolean stillValid(Player playerIn) {
        return !playerIn.isSpectator() && !this.heldStack.isEmpty();
    }

    public SpoilsBagMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, SpoilsBagMenu.getSpoilsBag(playerInventory));
    }

    public static ItemStack getSpoilsBag(Inventory playerInventory) {
        Player player = playerInventory.player;
        if (player.getMainHandItem().getItem() instanceof SpoilsBagItem) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().getItem() instanceof SpoilsBagItem) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    public SpoilsBagMenu(int id, Inventory playerInventory, ItemStack forceBelt) {
        super(ForceMenus.SPOILS_BAG.get(), id);
        if (forceBelt == null || forceBelt.isEmpty()) {
            playerInventory.player.closeContainer();
            return;
        }
        this.heldStack = forceBelt;
        int xPosC = 17;
        int yPosC = 20;
        IItemHandler itemHandler = (IItemHandler)forceBelt.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            for (int k = 0; k < 8; ++k) {
                this.addSlot((Slot)new SlotItemHandler(itemHandler, k, xPosC + k * 18, yPosC){

                    public boolean mayPlace(@Nonnull ItemStack stack) {
                        return false;
                    }
                });
            }
            int xPos = 8;
            int yPos = 54;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x, xPos + x * 18, yPos + 58));
            }
        } else {
            playerInventory.player.closeContainer();
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot;
        ItemStack itemstack = ItemStack.EMPTY;
        if (index <= 8 && (slot = (Slot)this.slots.get(index)) != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (itemstack.getItem() instanceof SpoilsBagItem) {
                return ItemStack.EMPTY;
            }
            int containerSlots = this.slots.size() - player.getInventory().items.size();
            if (index < containerSlots ? !this.moveItemStackTo(itemstack1, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

