/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu.engine;

import com.mrbysco.forcecraft.blockentities.ForceEngineBlockEntity;
import com.mrbysco.forcecraft.menu.engine.slot.FuelSlot;
import com.mrbysco.forcecraft.menu.engine.slot.OutputSlot;
import com.mrbysco.forcecraft.menu.engine.slot.ThrottleSlot;
import com.mrbysco.forcecraft.registry.ForceMenus;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class ForceEngineMenu
extends AbstractContainerMenu {
    private ForceEngineBlockEntity tile;
    private Player player;

    public ForceEngineMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ForceEngineMenu.getTileEntity(playerInventory, data));
    }

    private static ForceEngineBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof ForceEngineBlockEntity) {
            return (ForceEngineBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public ForceEngineMenu(int id, Inventory playerInventoryIn, ForceEngineBlockEntity te) {
        super(ForceMenus.FORCE_ENGINE.get(), id);
        this.tile = te;
        this.player = playerInventoryIn.player;
        this.addSlot((Slot)new FuelSlot((IItemHandler)te.inputHandler, 0, 42, 23));
        this.addSlot((Slot)new ThrottleSlot((IItemHandler)te.inputHandler, 1, 118, 23));
        this.addSlot((Slot)new OutputSlot((IItemHandler)te.outputHandler, 0, 42, 42));
        this.addSlot((Slot)new OutputSlot((IItemHandler)te.outputHandler, 1, 118, 42));
        int xPos = 8;
        int yPos = 79;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventoryIn, x, xPos + x * 18, yPos + 58));
        }
        this.trackFluids();
    }

    private void trackFluids() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return ForceEngineMenu.this.tile.getFuelAmount() & 0xFFFF;
            }

            public void set(int value) {
                int fluidStored = ForceEngineMenu.this.tile.getFuelAmount() & 0xFFFF0000;
                ForceEngineMenu.this.tile.setFuelAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return ForceEngineMenu.this.tile.getFuelAmount() >> 16 & 0xFFFF;
            }

            public void set(int value) {
                int fluidStored = ForceEngineMenu.this.tile.getFuelAmount() & 0xFFFF;
                ForceEngineMenu.this.tile.setFuelAmount(fluidStored | value << 16);
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return ForceEngineMenu.this.tile.getThrottleAmount() & 0xFFFF;
            }

            public void set(int value) {
                int fluidStored = ForceEngineMenu.this.tile.getThrottleAmount() & 0xFFFF0000;
                ForceEngineMenu.this.tile.setThrottleAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return ForceEngineMenu.this.tile.getThrottleAmount() >> 16 & 0xFFFF;
            }

            public void set(int value) {
                int fluidStored = ForceEngineMenu.this.tile.getThrottleAmount() & 0xFFFF;
                ForceEngineMenu.this.tile.setThrottleAmount(fluidStored | value << 16);
            }
        });
    }

    public ForceEngineBlockEntity getTile() {
        return this.tile;
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.isUsableByPlayer(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int containerSize = 4;
            if (index < 4 ? !this.moveItemStackTo(itemstack1, 4, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 4, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(this.player, itemstack1);
        }
        return itemstack;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }
}

