/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu.furnace;

import com.mrbysco.forcecraft.blockentities.furnace.AbstractForceFurnaceBlockEntity;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.menu.furnace.slot.ForceFurnaceFuelSlot;
import com.mrbysco.forcecraft.menu.furnace.slot.ForceFurnaceResultSlot;
import com.mrbysco.forcecraft.menu.furnace.slot.UpgradeSlot;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public abstract class AbstractForceFurnaceMenu
extends AbstractContainerMenu {
    private AbstractForceFurnaceBlockEntity tile;
    private IItemHandler furnaceInventory;
    private IItemHandler upgradeInventory;
    private ContainerData furnaceData;
    private Level level;

    public AbstractForceFurnaceMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, AbstractForceFurnaceMenu.getTileEntity(playerInventory, data));
    }

    protected static AbstractForceFurnaceBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof AbstractForceFurnaceBlockEntity) {
            return (AbstractForceFurnaceBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public AbstractForceFurnaceMenu(int id, Inventory playerInventoryIn, AbstractForceFurnaceBlockEntity te) {
        super(ForceMenus.FORCE_FURNACE.get(), id);
        this.tile = te;
        final Player player = playerInventoryIn.player;
        this.level = player.level();
        this.furnaceInventory = this.tile.handler;
        this.upgradeInventory = this.tile.upgradeHandler;
        this.furnaceData = this.tile.getFurnaceData();
        this.assertFurnaceSize(this.furnaceInventory, 3);
        this.assertFurnaceSize(this.upgradeInventory, 1);
        AbstractForceFurnaceMenu.checkContainerDataCount((ContainerData)this.furnaceData, (int)4);
        this.addSlot((Slot)new SlotItemHandler(this.furnaceInventory, 0, 56, 17));
        this.addSlot((Slot)new ForceFurnaceFuelSlot(this, this.furnaceInventory, 1, 56, 53));
        this.addSlot((Slot)new ForceFurnaceResultSlot(player, this.furnaceInventory, 2, 116, 35){

            @Override
            protected void checkTakeAchievements(ItemStack stack) {
                stack.onCraftedBy(player.level(), player, this.removeCount);
                if (player instanceof ServerPlayer) {
                    AbstractForceFurnaceMenu.this.tile.awardUsedRecipesAndPopExperience((ServerPlayer)player);
                }
                this.removeCount = 0;
                EventHooks.firePlayerSmeltedEvent((Player)player, (ItemStack)stack);
            }
        });
        this.addSlot((Slot)new UpgradeSlot(this.upgradeInventory, 0, 12, 12));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.addDataSlots(this.furnaceData);
    }

    public int getBurn() {
        return this.furnaceData.get(0);
    }

    protected void assertFurnaceSize(IItemHandler inventoryIn, int minSize) {
        int i = inventoryIn.getSlots();
        if (i < minSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + minSize);
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != 1 && index != 0) {
                if (this.hasRecipe(itemstack1)) {
                    if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (this.isFuel(itemstack1)) {
                    if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    if (AbstractForceFurnaceMenu.isUpgrade(itemstack1) && index == 3) {
                        itemstack1.shrink(1);
                        playerIn.level().playSound((Player)null, playerIn.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
                        return ItemStack.EMPTY;
                    }
                    if (index >= 4 && index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false)) {
                        return ItemStack.EMPTY;
                    }
                }
            } else if (!this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean hasRecipe(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor(this.getRecipeType(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    protected RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        RecipeType recipeType = RecipeType.SMELTING;
        ItemStack upgrade = this.upgradeInventory.getStackInSlot(0);
        if (!upgrade.isEmpty()) {
            if (upgrade.getItem() == ForceRegistry.FREEZING_CORE.get()) {
                return ForceRecipes.FREEZING.get();
            }
            if (upgrade.getItem() == ForceRegistry.GRINDING_CORE.get()) {
                return ForceRecipes.GRINDING.get();
            }
        }
        return recipeType;
    }

    public boolean isFuel(ItemStack stack) {
        return AbstractForceFurnaceBlockEntity.isFuel(stack);
    }

    public static boolean isUpgrade(ItemStack stack) {
        return stack.getItem() instanceof UpgradeCoreItem;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (clickTypeIn == ClickType.PICKUP_ALL && this.getCarried().getItem() instanceof UpgradeCoreItem) {
            return;
        }
        if (slotId == 3 && (slot = this.getSlot(slotId)).hasItem() && clickTypeIn != ClickType.QUICK_MOVE) {
            player.level().playSound((Player)null, player.blockPosition(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public int getCookProgressionScaled() {
        int i = this.furnaceData.get(2);
        int j = this.furnaceData.get(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getBurnLeftScaled() {
        int i = this.furnaceData.get(1);
        if (i == 0) {
            i = 200;
        }
        return this.furnaceData.get(0) * 13 / i;
    }

    public boolean isBurning() {
        return this.furnaceData.get(0) > 0;
    }
}

