/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.handler;

import com.mrbysco.forcecraft.attachment.storage.BeltStorage;
import com.mrbysco.forcecraft.attachment.storage.PackStorage;
import com.mrbysco.forcecraft.attachment.storage.StorageManager;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.menu.ForceBeltMenu;
import com.mrbysco.forcecraft.menu.ForcePackMenu;
import com.mrbysco.forcecraft.menu.ItemCardMenu;
import com.mrbysco.forcecraft.networking.message.OpenInventoryPayload;
import com.mrbysco.forcecraft.networking.message.PackChangePayload;
import com.mrbysco.forcecraft.networking.message.QuickUseBeltPayload;
import com.mrbysco.forcecraft.networking.message.RecipeToCardPayload;
import com.mrbysco.forcecraft.networking.message.SaveCardRecipePayload;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.FindingUtil;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleOpen(OpenInventoryPayload openData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            if (context.player().isPresent()) {
                Player player = (Player)context.player().get();
                if (openData.type() == 0) {
                    ItemStack beltStack;
                    Predicate<ItemStack> stackPredicate = stack -> stack.getItem() instanceof ForceBeltItem;
                    if (FindingUtil.hasSingleStackInHotbar(player, stackPredicate) && !(beltStack = FindingUtil.findInstanceStack(player, stackPredicate)).isEmpty()) {
                        Optional<BeltStorage> data = StorageManager.getBelt(beltStack);
                        data.ifPresent(belt -> player.openMenu((MenuProvider)new SimpleMenuProvider((id, pInv, pEntity) -> new ForceBeltMenu(id, pInv, belt.getInventory()), (Component)(beltStack.hasCustomHoverName() ? ((MutableComponent)beltStack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.belt")))));
                    }
                } else {
                    ItemStack packStack;
                    Predicate<ItemStack> stackPredicate = stack -> stack.getItem() instanceof ForcePackItem;
                    if (FindingUtil.hasSingleStackInHotbar(player, stackPredicate) && !(packStack = FindingUtil.findInstanceStack(player, stackPredicate)).isEmpty()) {
                        Optional<PackStorage> data = StorageManager.getPack(packStack);
                        data.ifPresent(pack -> player.openMenu((MenuProvider)new SimpleMenuProvider((id, pInv, pEntity) -> new ForcePackMenu(id, pInv, pack.getInventory()), (Component)(packStack.hasCustomHoverName() ? ((MutableComponent)packStack.getHoverName()).withStyle(ChatFormatting.BLACK) : Component.translatable((String)"forcecraft.container.pack"))), buf -> buf.writeInt(pack.getInventory().getUpgrades())));
                    }
                }
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"forcecraft.networking.open_inventory.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleQuickUse(QuickUseBeltPayload beltData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ItemStack beltStack;
            Predicate<ItemStack> stackPredicate;
            Player player;
            if (context.player().isPresent() && FindingUtil.hasSingleStackInHotbar(player = (Player)context.player().get(), stackPredicate = stack -> stack.getItem() instanceof ForceBeltItem) && !(beltStack = FindingUtil.findInstanceStack(player, stackPredicate)).isEmpty()) {
                Optional<BeltStorage> data = StorageManager.getBelt(beltStack);
                data.ifPresent(belt -> {
                    IItemHandler handler = belt.getInventory();
                    ItemStack stack = handler.getStackInSlot(beltData.slot());
                    Level level = player.level();
                    if (!stack.isEmpty()) {
                        stack.finishUsingItem(level, (LivingEntity)player);
                        level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), stack.getDrinkingSound(), player.getSoundSource(), 0.5f, player.level().random.nextFloat() * 0.1f + 0.9f);
                    }
                });
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"forcecraft.networking.quick_use_belt.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handlePackChange(PackChangePayload changeData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Player player;
            ItemStack stack;
            if (context.player().isPresent() && ((stack = (player = (Player)context.player().get()).getItemInHand(changeData.hand())).getItem() == ForceRegistry.FORCE_PACK.get() || stack.getItem() == ForceRegistry.FORCE_BELT.get())) {
                CompoundTag tag = stack.getOrCreateTag();
                tag.putInt("Color", changeData.color());
                stack.setTag(tag);
                String customName = changeData.customName();
                if (customName.isEmpty()) {
                    stack.resetHoverName();
                } else if (!stack.getHoverName().getString().equals(customName)) {
                    stack.setHoverName((Component)Component.literal((String)customName).withStyle(ChatFormatting.YELLOW));
                }
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"forcecraft.networking.pack_change.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleCard(RecipeToCardPayload recipeData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            if (context.player().isPresent()) {
                AbstractContainerMenu patt7212$temp;
                Player player = (Player)context.player().get();
                ItemStack mainhand = ItemStack.EMPTY;
                if (player.getMainHandItem().getItem() instanceof ItemCardItem) {
                    mainhand = player.getMainHandItem();
                } else if (player.getOffhandItem().getItem() instanceof ItemCardItem) {
                    mainhand = player.getOffhandItem();
                }
                if (!mainhand.isEmpty() && mainhand.getItem() == ForceRegistry.ITEM_CARD.get() && (patt7212$temp = player.containerMenu) instanceof ItemCardMenu) {
                    ItemCardMenu itemCardContainer = (ItemCardMenu)patt7212$temp;
                    itemCardContainer.setMatrixContents(player, recipeData.stacks());
                }
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"forcecraft.networking.recipe_to_card.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSaveCard(SaveCardRecipePayload saveData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt7781$temp;
            if (context.player().isPresent() && (patt7781$temp = context.player().get()) instanceof ServerPlayer) {
                AbstractContainerMenu patt7990$temp;
                ServerPlayer player = (ServerPlayer)patt7781$temp;
                Level level = player.level();
                ItemStack stack = ServerPayloadHandler.getCardStack((Player)player);
                if (!stack.isEmpty() && (patt7990$temp = player.containerMenu) instanceof ItemCardMenu) {
                    ItemCardMenu itemCardContainer = (ItemCardMenu)patt7990$temp;
                    CraftingContainer craftMatrix = itemCardContainer.getCraftMatrix();
                    ResultContainer craftResult = itemCardContainer.getCraftResult();
                    Optional iRecipe = player.server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)craftMatrix, level);
                    iRecipe.ifPresent(holder -> {
                        CompoundTag tag = stack.getOrCreateTag();
                        CompoundTag recipeContents = new CompoundTag();
                        for (int i = 0; i < craftMatrix.getContainerSize(); ++i) {
                            recipeContents.put("slot_" + i, (Tag)craftMatrix.getItem(i).save(new CompoundTag()));
                        }
                        recipeContents.put("result", (Tag)craftResult.getItem(0).save(new CompoundTag()));
                        tag.put("RecipeContents", (Tag)recipeContents);
                        stack.setTag(tag);
                    });
                }
                player.sendSystemMessage((Component)Component.literal((String)"Recipe saved").withStyle(ChatFormatting.YELLOW));
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"forcecraft.networking.save_card.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    private static ItemStack getCardStack(Player player) {
        if (player.getMainHandItem().getItem() instanceof ItemCardItem) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().getItem() instanceof ItemCardItem) {
            return player.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }
}

