/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FreezingRecipe
extends MultipleOutputFurnaceRecipe {
    public FreezingRecipe(String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float experience, int freezingTime) {
        super(ForceRecipes.FREEZING.get(), groupIn, ingredientIn, results, 1.0f, experience, freezingTime);
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ForceRegistry.FREEZING_CORE.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.FREEZING_SERIALIZER.get();
    }

    public static class SerializerFreezingRecipe
    implements RecipeSerializer<FreezingRecipe> {
        public static final Codec<FreezingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> ((FreezingRecipe)recipe).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> ((FreezingRecipe)recipe).ingredient), (App)ItemStack.RESULT_CODEC.codec().listOf().fieldOf("results").flatXmap(array -> {
            Object[] stacks = (ItemStack[])array.toArray(ItemStack[]::new);
            if (stacks.length == 0) {
                return DataResult.error(() -> "No results for freezing recipe");
            }
            return stacks.length > 2 ? DataResult.error(() -> "Too many itemstacks for freezing recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)ItemStack.EMPTY, (Object[])stacks));
        }, DataResult::success).forGetter(recipe -> recipe.results), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(((FreezingRecipe)recipe).experience)), (App)Codec.INT.fieldOf("freezingTime").orElse((Object)200).forGetter(recipe -> ((FreezingRecipe)recipe).cookingTime)).apply((Applicative)instance, FreezingRecipe::new));

        public Codec<FreezingRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public FreezingRecipe fromNetwork(FriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            int size = buffer.readVarInt();
            NonNullList resultList = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            for (int j = 0; j < resultList.size(); ++j) {
                resultList.set(j, (Object)buffer.readItem());
            }
            float f = buffer.readFloat();
            int i = buffer.readVarInt();
            return new FreezingRecipe(s, ingredient, (NonNullList<ItemStack>)resultList, f, i);
        }

        public void toNetwork(FriendlyByteBuf buffer, FreezingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            recipe.ingredient.toNetwork(buffer);
            buffer.writeVarInt(recipe.results.size());
            for (ItemStack stack : recipe.results) {
                buffer.writeItem(stack);
            }
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.cookingTime);
        }
    }
}

