/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GrindingRecipe
extends MultipleOutputFurnaceRecipe {
    public GrindingRecipe(String groupIn, Ingredient ingredientIn, NonNullList<ItemStack> results, float secondaryChance, float experience, int processTime) {
        super(ForceRecipes.GRINDING.get(), groupIn, ingredientIn, results, secondaryChance, experience, processTime);
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ForceRegistry.GRINDING_CORE.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.GRINDING_SERIALIZER.get();
    }

    public static class SerializerGrindingRecipe
    implements RecipeSerializer<GrindingRecipe> {
        public static final Codec<GrindingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> ((GrindingRecipe)recipe).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> ((GrindingRecipe)recipe).ingredient), (App)ItemStack.RESULT_CODEC.codec().listOf().fieldOf("results").flatXmap(array -> {
            Object[] stacks = (ItemStack[])array.toArray(ItemStack[]::new);
            if (stacks.length == 0) {
                return DataResult.error(() -> "No results for grinding recipe");
            }
            return stacks.length > 2 ? DataResult.error(() -> "Too many itemstacks for grinding recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)ItemStack.EMPTY, (Object[])stacks));
        }, DataResult::success).forGetter(recipe -> recipe.results), (App)Codec.FLOAT.fieldOf("secondaryChance").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.secondaryChance)), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(((GrindingRecipe)recipe).experience)), (App)Codec.INT.fieldOf("processTime").orElse((Object)200).forGetter(recipe -> ((GrindingRecipe)recipe).cookingTime)).apply((Applicative)instance, GrindingRecipe::new));

        public Codec<GrindingRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public GrindingRecipe fromNetwork(FriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            int size = buffer.readVarInt();
            NonNullList resultList = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            for (int j = 0; j < resultList.size(); ++j) {
                resultList.set(j, (Object)buffer.readItem());
            }
            float chance = buffer.readFloat();
            float f = buffer.readFloat();
            int i = buffer.readVarInt();
            return new GrindingRecipe(s, ingredient, (NonNullList<ItemStack>)resultList, chance, f, i);
        }

        public void toNetwork(FriendlyByteBuf buffer, GrindingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            recipe.ingredient.toNetwork(buffer);
            buffer.writeVarInt(recipe.results.size());
            for (ItemStack stack : recipe.results) {
                buffer.writeItem(stack);
            }
            buffer.writeFloat(recipe.secondaryChance);
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.cookingTime);
        }
    }
}

