/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.attachment.storage.PackStackHandler;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.blockentities.InfuserModifierType;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class InfuseRecipe
implements Recipe<InfuserBlockEntity> {
    private static final int MAX_SLOTS = 8;
    protected Ingredient ingredient;
    protected InfuserModifierType resultModifier;
    protected ItemStack output;
    protected UpgradeBookTier tier;
    protected Ingredient center;
    protected int time;

    public InfuseRecipe(Ingredient center, Ingredient input, InfuserModifierType resultType, UpgradeBookTier tier, ItemStack outputStack, int time) {
        this.ingredient = input;
        this.center = center;
        this.output = outputStack;
        this.resultModifier = resultType;
        this.tier = tier;
        this.time = time;
    }

    public boolean isSpecial() {
        return true;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean matches(InfuserBlockEntity inv, Level level) {
        for (int i = 0; i < inv.handler.getSlots(); ++i) {
            ItemStack stack = inv.handler.getStackInSlot(i);
            if (i >= 8) continue;
            return this.matchesModifier(inv, stack, false);
        }
        return false;
    }

    public boolean matchesModifier(InfuserBlockEntity inv, ItemStack modifier, boolean ignoreInfused) {
        UpgradeBookData bd = new UpgradeBookData(inv.getBookInSlot());
        int bookTier = bd.getTier().ordinal();
        if (this.getTier().ordinal() > bookTier) {
            return false;
        }
        ItemStack centerStack = inv.handler.getStackInSlot(8);
        boolean toolMatches = this.matchesTool(centerStack, ignoreInfused);
        boolean modifierMatches = this.matchesModifier(centerStack, modifier);
        return toolMatches && modifierMatches;
    }

    public boolean matchesModifier(InfuserBlockEntity inv, ItemStack modifierStack) {
        ItemStack centerStack = inv.handler.getStackInSlot(8);
        return this.matchesModifier(centerStack, modifierStack);
    }

    public boolean matchesModifier(ItemStack centerStack, ItemStack modifierStack) {
        IItemHandler handler;
        if (modifierStack.getItem() == ForceRegistry.FORCE_PACK_UPGRADE.get() && (handler = (IItemHandler)centerStack.getCapability(Capabilities.ItemHandler.ITEM)) instanceof PackStackHandler && ((PackStackHandler)handler).getUpgrades() != this.getTier().ordinal() - 2) {
            return false;
        }
        return this.ingredient.test(modifierStack);
    }

    public boolean matchesTool(ItemStack toolStack, boolean ignoreInfused) {
        if (!this.center.test(toolStack)) {
            return false;
        }
        if (!ignoreInfused) {
            return !toolStack.hasTag() || !toolStack.getTag().getBoolean("ForceInfused");
        }
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return height == 1 && width < 8;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean hasOutput() {
        return !this.output.isEmpty();
    }

    public ItemStack assemble(InfuserBlockEntity inv, RegistryAccess registryAccess) {
        return this.getResultItem(registryAccess);
    }

    public RecipeType<?> getType() {
        return ForceRecipes.INFUSER_TYPE.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getCenter() {
        return this.center;
    }

    public InfuserModifierType getModifier() {
        return this.resultModifier;
    }

    public void setModifier(InfuserModifierType modifier) {
        this.resultModifier = modifier;
    }

    public UpgradeBookTier getTier() {
        return this.tier;
    }

    public void setTier(UpgradeBookTier tier) {
        this.tier = tier;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.center);
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.INFUSER_SERIALIZER.get();
    }

    public static class SerializeInfuserRecipe
    implements RecipeSerializer<InfuseRecipe> {
        private static final Codec<InfuseRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("center").forGetter(recipe -> recipe.center), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)InfuserModifierType.CODEC.fieldOf("resultType").forGetter(recipe -> recipe.resultModifier), (App)UpgradeBookTier.CODEC.fieldOf("tier").forGetter(recipe -> recipe.tier), (App)ExtraCodecs.strictOptionalField((Codec)ItemStack.ITEM_WITH_COUNT_CODEC, (String)"output", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.output), (App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time)).apply((Applicative)instance, InfuseRecipe::new));

        public Codec<InfuseRecipe> codec() {
            return CODEC;
        }

        public void toNetwork(FriendlyByteBuf buffer, InfuseRecipe recipe) {
            recipe.center.toNetwork(buffer);
            recipe.ingredient.toNetwork(buffer);
            buffer.writeEnum((Enum)recipe.resultModifier);
            buffer.writeEnum((Enum)recipe.tier);
            buffer.writeItem(recipe.getResultItem(null));
            buffer.writeInt(recipe.getTime());
        }

        public InfuseRecipe fromNetwork(FriendlyByteBuf buffer) {
            Ingredient center = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            Ingredient ing = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            InfuserModifierType infuserType = (InfuserModifierType)buffer.readEnum(InfuserModifierType.class);
            UpgradeBookTier tier = (UpgradeBookTier)buffer.readEnum(UpgradeBookTier.class);
            ItemStack output = buffer.readItem();
            int time = buffer.readInt();
            return new InfuseRecipe(center, ing, infuserType, tier, output, time);
        }
    }
}

