/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class ShapedNoRemainderRecipe
extends ShapedRecipe {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ShapedNoRemainderRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.showNotification = showNotification;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.SHAPED_NO_REMAINDER_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        return nonnulllist;
    }

    public static class SerializerShapedNoRemainderRecipe
    implements RecipeSerializer<ShapedNoRemainderRecipe> {
        public static final Codec<ShapedNoRemainderRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, ShapedNoRemainderRecipe::new));

        public Codec<ShapedNoRemainderRecipe> codec() {
            return CODEC;
        }

        public ShapedNoRemainderRecipe fromNetwork(FriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)pBuffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.fromNetwork((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.readItem();
            boolean flag = pBuffer.readBoolean();
            return new ShapedNoRemainderRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ShapedNoRemainderRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            pBuffer.writeEnum((Enum)pRecipe.category);
            pRecipe.pattern.toNetwork(pBuffer);
            pBuffer.writeItem(pRecipe.result);
            pBuffer.writeBoolean(pRecipe.showNotification);
        }
    }
}

