/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.forcecraft.items.ExperienceTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.Nullable;

public class TransmutationRecipe
implements CraftingRecipe {
    private final String group;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    public TransmutationRecipe(String groupIn, ItemStack result, NonNullList<Ingredient> ingredients) {
        this.group = groupIn;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public RecipeSerializer<?> getSerializer() {
        return ForceRecipeSerializers.TRANSMUTATION_SERIALIZER.get();
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean isSpecial() {
        return false;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        StackedContents stackedContents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int stacks = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            ++stacks;
            if (itemstack.getItem() instanceof ForceRodItem) {
                if (this.isSimple) {
                    stackedContents.accountStack(itemstack, 1);
                    continue;
                }
                inputs.add(itemstack);
                continue;
            }
            if (itemstack.getItem() instanceof ExperienceTomeItem) {
                if (itemstack.hasTag() && itemstack.getTag().getInt("Experience") < 100) {
                    return false;
                }
                ItemStack experienceTome = new ItemStack((ItemLike)ForceRegistry.EXPERIENCE_TOME.get());
                CompoundTag tag = experienceTome.getOrCreateTag();
                tag.putInt("Experience", 100);
                experienceTome.setTag(tag);
                if (this.isSimple) {
                    stackedContents.accountStack(experienceTome, 1);
                    continue;
                }
                inputs.add(experienceTome);
                continue;
            }
            if (itemstack.isDamaged()) continue;
            if (this.isSimple) {
                stackedContents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return stacks == this.ingredients.size() && (this.isSimple ? stackedContents.canCraft((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack resultStack = this.getResultItem(registryAccess).copy();
        for (int j = 0; j < inv.getContainerSize(); ++j) {
            Map enchantmentMap;
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.getItem() instanceof ExperienceTomeItem) {
                CompoundTag tag = itemstack.getOrCreateTag();
                int experience = tag.getInt("Experience");
                int count = Math.min((int)((float)experience / 100.0f), 64);
                resultStack.setCount(count);
            }
            if (!(itemstack.getItem() instanceof EnchantedBookItem) || !(resultStack.getItem() instanceof ExperienceBottleItem) || (enchantmentMap = EnchantmentHelper.getEnchantments((ItemStack)itemstack)).isEmpty()) continue;
            int amount = 0;
            for (Map.Entry entry : enchantmentMap.entrySet()) {
                amount += ((Integer)entry.getValue()).intValue();
            }
            resultStack.setCount(Mth.clamp((int)amount, (int)1, (int)64));
        }
        return resultStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack1;
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (itemstack.getItem() instanceof ForceRodItem) {
                itemstack1 = itemstack.copy();
                ForceRodItem rod = (ForceRodItem)itemstack1.getItem();
                int damage = rod.damageItem(itemstack1, 1);
                if (itemstack1.getItem().getDamage(itemstack1) >= itemstack1.getMaxDamage()) {
                    itemstack1.shrink(1);
                    continue;
                }
                itemstack1.setDamageValue(itemstack1.getDamageValue() + damage);
                nonnulllist.set(i, (Object)itemstack1);
                continue;
            }
            if (!(itemstack.getItem() instanceof ExperienceTomeItem)) continue;
            itemstack1 = itemstack.copy();
            CompoundTag tag = itemstack.getOrCreateTag();
            int experience = tag.getInt("Experience");
            int count = (int)((float)experience / 100.0f);
            int newExperience = count > 64 ? experience - 6400 : experience - count * 100;
            tag.putInt("Experience", newExperience);
            itemstack1.setTag(tag);
            nonnulllist.set(i, (Object)itemstack1);
        }
        return nonnulllist;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class SerializerTransmutationRecipe
    implements RecipeSerializer<TransmutationRecipe> {
        private static final Codec<TransmutationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(array -> {
            Object[] aingredient = (Ingredient[])array.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for transmutation recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, TransmutationRecipe::new));

        public Codec<TransmutationRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public TransmutationRecipe fromNetwork(FriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.readItem();
            return new TransmutationRecipe(s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf buffer, TransmutationRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(recipe.result);
        }
    }
}

