/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.util;

import com.mrbysco.forcecraft.blocks.flammable.ForceLogBlock;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class ForceUtils {
    public static boolean teleportToLocation(Player player, double x, double y, double z, boolean broadcast) {
        Level level = player.level();
        player.teleportTo(x, y, z);
        if (broadcast) {
            level.broadcastEntityEvent((Entity)player, (byte)46);
        }
        return true;
    }

    public static void removeEnchant(Enchantment enchantment, ItemStack stack) {
        Map enchantMap = EnchantmentHelper.getEnchantments((ItemStack)stack);
        if (enchantMap.containsKey(enchantment)) {
            enchantMap.remove(enchantment);
        }
        EnchantmentHelper.setEnchantments((Map)enchantMap, (ItemStack)stack);
    }

    public static boolean isTree(Level level, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.getY() <= pos.getY() || !ForceUtils.isLog(level, candidate)) continue;
            pos = candidate.above();
            while (ForceUtils.isLog(level, pos)) {
                pos = pos.above();
            }
            candidates.add(pos.north());
            candidates.add(pos.east());
            candidates.add(pos.south());
            candidates.add(pos.west());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.offset(o + x, o + y, o + z);
                    BlockState state = level.getBlockState(leaf);
                    if (!state.is(BlockTags.LEAVES) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLog(Level level, BlockPos pos) {
        return level.getBlockState(pos).is(BlockTags.LOGS) || level.getBlockState(pos).getBlock() instanceof ForceLogBlock;
    }

    public static void breakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos, BlockPos refPos) {
        if (!ForceUtils.canBreakExtraBlock(stack, level, player, pos, refPos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        FluidState fluidState = level.getFluidState(pos);
        Block block = state.getBlock();
        stack.mineBlock(level, state, pos, player);
        if (!level.isClientSide) {
            int xp = CommonHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.playerWillDestroy(level, pos, state, player);
                block.playerDestroy(level, player, pos, state, tileEntity, stack);
                block.popExperience((ServerLevel)level, pos, xp);
            }
            ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
        } else {
            level.globalLevelEvent(2001, pos, Block.getId((BlockState)state));
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.playerWillDestroy(level, pos, state, player);
            }
            stack.mineBlock(level, state, pos, player);
            if (stack.getCount() == 0 && stack == player.getMainHandItem()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            ClientPacketListener netHandlerPlayClient = Minecraft.getInstance().getConnection();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, Direction.DOWN));
        }
    }

    private static boolean canBreakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos, BlockPos refPos) {
        if (level.isEmptyBlock(pos)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        FluidState fluidState = level.getFluidState(pos);
        Block block = state.getBlock();
        BlockState refState = level.getBlockState(refPos);
        float refStrength = refState.getDestroyProgress(player, (BlockGetter)level, refPos);
        float strength = state.getDestroyProgress(player, (BlockGetter)level, pos);
        if (!CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)player) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.getAbilities().instabuild) {
            block.playerWillDestroy(level, pos, state, player);
            if (block.onDestroyedByPlayer(state, level, pos, player, false, fluidState)) {
                block.playerWillDestroy(level, pos, state, player);
            }
            if (!level.isClientSide) {
                ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
            return false;
        }
        return true;
    }

    public static boolean isFakePlayer(Entity player) {
        return player instanceof FakePlayer;
    }

    public static String resource(String res) {
        return String.format("%s:%s", "forcecraft", res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation("forcecraft", res);
    }

    public static void teleportRandomly(LivingEntity livingEntity) {
        if (!livingEntity.level().isClientSide() && livingEntity.isAlive() && !livingEntity.isInWaterOrBubble()) {
            double d0 = livingEntity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * 32.0;
            double d1 = livingEntity.getY() + (double)(livingEntity.getRandom().nextInt(32) - 16);
            double d2 = livingEntity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * 32.0;
            ForceUtils.teleportTo(livingEntity, d0, d1, d2);
        }
    }

    public static void teleportTo(LivingEntity living, double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutable.getY() > 0 && !living.level().getBlockState((BlockPos)blockpos$mutable).blocksMotion()) {
            blockpos$mutable.move(Direction.DOWN);
        }
        BlockState blockstate = living.level().getBlockState((BlockPos)blockpos$mutable);
        boolean flag = blockstate.blocksMotion();
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = new EntityTeleportEvent.EnderEntity(living, x, y, z);
            if (event.isCanceled()) {
                return;
            }
            boolean flag2 = living.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !living.isSilent()) {
                living.level().playSound((Player)null, living.xo, living.yo, living.zo, SoundEvents.ENDERMAN_TELEPORT, living.getSoundSource(), 1.0f, 1.0f);
                living.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
        }
    }
}

