/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.util;

import java.util.function.Predicate;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemHandlerUtils {
    public static ItemStack getFirstItem(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return ItemStack.EMPTY;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasItems(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return false;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFull(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.isEmpty() && stack.getCount() >= stack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static int getUsedSlots(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        int usedSlots = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ++usedSlots;
        }
        return usedSlots;
    }

    public static boolean extractStackFromPlayer(Inventory inventory, IItemHandler targetHandler, Predicate<ItemStack> stackPredicate) {
        if (targetHandler != null) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (!stackPredicate.test(stack)) continue;
                ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)stack, (boolean)false);
                inventory.setItem(i, restStack);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getAndSplit(IItemHandler itemhandler, int index, int amount) {
        return index >= 0 && index < itemhandler.getSlots() && !itemhandler.getStackInSlot(index).isEmpty() && amount > 0 ? itemhandler.getStackInSlot(index).split(amount) : ItemStack.EMPTY;
    }

    public static ItemStack getAndRemove(IItemHandler itemhandler, int index) {
        if (index >= 0 && index < itemhandler.getSlots() && itemhandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)itemhandler;
            modifiable.setStackInSlot(index, ItemStack.EMPTY);
            return modifiable.getStackInSlot(index);
        }
        return ItemStack.EMPTY;
    }
}

