/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.world.feature;

import com.mrbysco.forcecraft.modifier.AddConfigFeatureBiomeModifier;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.world.feature.ForceFeatureKeys;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ForceBiomeModifiers {
    protected static final ResourceKey<BiomeModifier> ADD_FORCE_ORE_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_force_ore"));
    protected static final ResourceKey<BiomeModifier> ADD_FORCE_ORE_BURIED_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_force_ore_buried"));
    protected static final ResourceKey<BiomeModifier> ADD_FORCE_TREE = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_force_tree"));
    protected static final ResourceKey<BiomeModifier> ADD_CHU_CHU_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_chu_chu"));
    protected static final ResourceKey<BiomeModifier> ADD_SWAMP_CHU_CHU_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_swamp_chu_chu"));
    protected static final ResourceKey<BiomeModifier> ADD_CREEPER_TOT_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_creeper_tot"));
    protected static final ResourceKey<BiomeModifier> ADD_ENDER_TOT_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_ender_tot"));
    protected static final ResourceKey<BiomeModifier> ADD_FAIRY_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("forcecraft", "add_fairy"));

    public static void modifierBootstrap(BootstapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter placedGetter = context.lookup(Registries.PLACED_FEATURE);
        HolderSet.Named overworldHolder = biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderSet.Named forestHolder = biomeGetter.getOrThrow(BiomeTags.IS_FOREST);
        HolderSet.Named swampHolder = biomeGetter.getOrThrow(Tags.Biomes.IS_SWAMP);
        context.register(ADD_FORCE_ORE_MODIFIER, (Object)new AddConfigFeatureBiomeModifier((HolderSet<Biome>)overworldHolder, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ForceFeatureKeys.PLACED_ORE_FORCE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "force_ore"));
        context.register(ADD_FORCE_ORE_BURIED_MODIFIER, (Object)new AddConfigFeatureBiomeModifier((HolderSet<Biome>)overworldHolder, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ForceFeatureKeys.PLACED_ORE_FORCE_BURIED)}), GenerationStep.Decoration.UNDERGROUND_ORES, "force_ore"));
        context.register(ADD_FORCE_TREE, (Object)new AddConfigFeatureBiomeModifier((HolderSet<Biome>)forestHolder, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ForceFeatureKeys.PLACED_FORCE_TREE)}), GenerationStep.Decoration.VEGETAL_DECORATION, "force_tree"));
        context.register(ADD_CHU_CHU_MODIFIER, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)overworldHolder, List.of(new MobSpawnSettings.SpawnerData(ForceEntities.RED_CHU_CHU.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData(ForceEntities.GREEN_CHU_CHU.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData(ForceEntities.BLUE_CHU_CHU.get(), 100, 1, 1), new MobSpawnSettings.SpawnerData(ForceEntities.GOLD_CHU_CHU.get(), 100, 1, 1))));
        context.register(ADD_SWAMP_CHU_CHU_MODIFIER, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)swampHolder, List.of(new MobSpawnSettings.SpawnerData(ForceEntities.RED_CHU_CHU.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData(ForceEntities.GREEN_CHU_CHU.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData(ForceEntities.BLUE_CHU_CHU.get(), 1, 1, 1), new MobSpawnSettings.SpawnerData(ForceEntities.GOLD_CHU_CHU.get(), 1, 1, 1))));
        context.register(ADD_CREEPER_TOT_MODIFIER, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)overworldHolder, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData(ForceEntities.CREEPER_TOT.get(), 25, 1, 1)));
        context.register(ADD_ENDER_TOT_MODIFIER, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)overworldHolder, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData(ForceEntities.ENDER_TOT.get(), 5, 1, 1)));
        context.register(ADD_FAIRY_MODIFIER, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)overworldHolder, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData(ForceEntities.FAIRY.get(), 4, 1, 2)));
    }
}

