/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmptyEmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.screen.tooltip.RemainderTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class EmiStack
implements EmiIngredient {
    public static final EmiStack EMPTY = new EmptyEmiStack();
    private EmiStack remainder = EMPTY;
    protected Comparison comparison = Comparison.DEFAULT_COMPARISON;
    protected long amount = 1L;
    protected float chance = 1.0f;

    @Override
    public List<EmiStack> getEmiStacks() {
        return List.of(this);
    }

    public EmiStack getRemainder() {
        return this.remainder;
    }

    public EmiStack setRemainder(EmiStack stack) {
        if (stack == this) {
            stack = stack.copy();
        }
        this.remainder = stack;
        return this;
    }

    public EmiStack comparison(Function<Comparison, Comparison> comparison) {
        this.comparison = comparison.apply(this.comparison);
        return this;
    }

    public EmiStack comparison(Comparison comparison) {
        this.comparison = comparison;
        return this;
    }

    @Override
    public abstract EmiStack copy();

    @Override
    public abstract boolean isEmpty();

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public EmiStack setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public EmiStack setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public abstract CompoundTag getNbt();

    public boolean hasNbt() {
        return this.getNbt() != null;
    }

    public abstract Object getKey();

    @Nullable
    public <T> T getKeyOfType(Class<T> clazz) {
        Object o = this.getKey();
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    public abstract ResourceLocation getId();

    public ItemStack getItemStack() {
        return ItemStack.EMPTY;
    }

    public boolean isEqual(EmiStack stack) {
        Comparison b;
        if (!this.getKey().equals(stack.getKey())) {
            return false;
        }
        Comparison a = this.comparison == Comparison.DEFAULT_COMPARISON ? EmiComparisonDefaults.get(this.getKey()) : this.comparison;
        Comparison comparison = b = stack.comparison == Comparison.DEFAULT_COMPARISON ? EmiComparisonDefaults.get(stack.getKey()) : stack.comparison;
        if (a == b) {
            return a.compare(this, stack);
        }
        return a.compare(this, stack) && b.compare(this, stack);
    }

    public boolean isEqual(EmiStack stack, Comparison comparison) {
        return this.getKey().equals(stack.getKey()) && comparison.compare(this, stack);
    }

    public abstract List<Component> getTooltipText();

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        if (!this.getRemainder().isEmpty()) {
            list.add(new RemainderTooltipComponent(this));
        }
        return list;
    }

    public abstract Component getName();

    public boolean equals(Object obj) {
        if (obj instanceof EmiStack) {
            EmiStack stack = (EmiStack)obj;
            return this.isEqual(stack);
        }
        if (obj instanceof EmiIngredient) {
            EmiIngredient stack = (EmiIngredient)obj;
            return EmiIngredient.areEqual(this, stack);
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        String s = String.valueOf(this.getKey());
        CompoundTag nbt = this.getNbt();
        if (nbt != null) {
            s = s + String.valueOf(nbt);
        }
        return s + " x" + this.getAmount();
    }

    public static EmiStack of(ItemStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return new ItemEmiStack(stack);
    }

    public static EmiStack of(ItemStack stack, long amount) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return new ItemEmiStack(stack, amount);
    }

    public static EmiStack of(ItemLike item) {
        return EmiStack.of(item.asItem().getDefaultInstance(), 1L);
    }

    public static EmiStack of(ItemLike item, long amount) {
        return EmiStack.of(item.asItem().getDefaultInstance(), amount);
    }

    public static EmiStack of(ItemLike item, CompoundTag nbt) {
        return EmiStack.of(item, nbt, 1L);
    }

    public static EmiStack of(ItemLike item, CompoundTag nbt, long amount) {
        return new ItemEmiStack(item.asItem(), nbt, amount);
    }

    public static EmiStack of(Fluid fluid) {
        return EmiStack.of(fluid, EmiPort.emptyExtraData());
    }

    public static EmiStack of(Fluid fluid, long amount) {
        return EmiStack.of(fluid, EmiPort.emptyExtraData(), amount);
    }

    public static EmiStack of(Fluid fluid, CompoundTag nbt) {
        return EmiStack.of(fluid, nbt, 0L);
    }

    public static EmiStack of(Fluid fluid, CompoundTag nbt, long amount) {
        FlowingFluid ff;
        if (fluid instanceof FlowingFluid && (ff = (FlowingFluid)fluid).getSource() != Fluids.EMPTY) {
            fluid = ff.getSource();
        }
        if (fluid == Fluids.EMPTY) {
            return EMPTY;
        }
        return new FluidEmiStack(fluid, nbt, amount);
    }

    static abstract class Entry<T> {
        Entry() {
        }
    }
}

