/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.widget;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.platform.EmiAgnos;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class TankWidget
extends SlotWidget {
    private final long capacity;

    public TankWidget(EmiIngredient stack, int x, int y, int width, int height, long capacity) {
        super(stack, x, y);
        this.bounds = new Bounds(x, y, width, height);
        this.capacity = capacity;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public SlotWidget backgroundTexture(ResourceLocation id, int u, int v) {
        return super.backgroundTexture(this.textureId, u, v);
    }

    @Override
    public void drawStack(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        EmiIngredient ingredient = this.getStack();
        for (EmiStack stack : ingredient.getEmiStacks()) {
            Object object = stack.getKey();
            if (!(object instanceof Fluid)) continue;
            Fluid fluid = (Fluid)object;
            FluidEmiStack fes = new FluidEmiStack(fluid, stack.getNbt(), ingredient.getAmount());
            boolean floaty = EmiAgnos.isFloatyFluid(fes);
            Bounds bounds = this.getBounds();
            int x = bounds.x() + 1;
            int y = bounds.y() + 1;
            int w = bounds.width() - 2;
            int h = bounds.height() - 2;
            int filledHeight = Math.max(1, (int)Math.min((long)h, fes.getAmount() * (long)h / this.capacity));
            int sy = floaty ? y : y + h;
            for (int oy = 0; oy < filledHeight; oy += 16) {
                int rh = Math.min(16, filledHeight - oy);
                for (int ox = 0; ox < w; ox += 16) {
                    int rw = Math.min(16, w - ox);
                    if (floaty) {
                        EmiAgnos.renderFluid(fes, draw.pose(), x + ox, sy + oy, delta, 0, 0, rw, rh);
                        continue;
                    }
                    EmiAgnos.renderFluid(fes, draw.pose(), x + ox, sy + (oy + rh) * -1, delta, 0, 16 - rh, rw, rh);
                }
            }
            return;
        }
    }
}

