/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.chess;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.chess.ChessMove;
import dev.emi.emi.chess.ChessPiece;
import dev.emi.emi.chess.ChessTooltipComponent;
import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.chess.PieceColor;
import dev.emi.emi.chess.PieceType;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;

class ChessEmiStack
extends EmiStack {
    public final int position;

    public ChessEmiStack(int position) {
        this.position = position;
    }

    @Override
    public void render(GuiGraphics raw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        ChessPiece piece = EmiChess.getBoard().get(this.position);
        RenderSystem.enableDepthTest();
        EmiChess chess = EmiChess.get();
        if (chess.pendingPromotion != -1) {
            int dir;
            PieceType type = null;
            int n = dir = chess.pendingPromotion > 31 ? -8 : 8;
            if (this.position == chess.pendingPromotion) {
                type = PieceType.QUEEN;
            } else if (this.position == chess.pendingPromotion + dir) {
                type = PieceType.KNIGHT;
            } else if (this.position == chess.pendingPromotion + dir * 2) {
                type = PieceType.ROOK;
            } else if (this.position == chess.pendingPromotion + dir * 3) {
                type = PieceType.BISHOP;
            }
            if (type != null) {
                context.push();
                context.matrices().translate(0.0f, 0.0f, 10.0f);
                context.fill(x - 1, y - 1, 18, 18, 0x55000000);
                context.matrices().translate(0.0f, 0.0f, 90.0f);
                context.drawTexture(EmiRenderHelper.PIECES, x, y, 100, type.u, chess.pendingPromotion > 31 ? 0.0f : 16.0f, 16, 16, 256, 256);
                context.pop();
                return;
            }
        }
        context.push();
        context.matrices().translate(0.0f, 0.0f, 10.0f);
        if (chess.isTarget(this.position)) {
            context.fill(x - 1, y - 1, 18, 18, 0x5555FF00);
        }
        boolean dragging = !EmiScreenManager.draggedStack.isEmpty();
        ChessMove move = chess.board.lastMove;
        if (!(dragging || move == null || move.start() != this.position && move.end() != this.position)) {
            context.fill(x - 1, y - 1, 18, 18, 0x55AAAA00);
        }
        if (!dragging && piece != null && piece.type() == PieceType.KING && chess.board.isChecked(piece.color())) {
            context.fill(x - 1, y - 1, 18, 18, 0x55FF0000);
        }
        context.pop();
        if (piece != null) {
            context.push();
            context.matrices().translate(0.0f, 0.0f, 100.0f);
            context.drawTexture(EmiRenderHelper.PIECES, x, y, 100, piece.type().u, piece.color() == PieceColor.BLACK ? 0.0f : 16.0f, 16, 16, 256, 256);
            context.pop();
        }
    }

    @Override
    public EmiStack copy() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return EmiChess.get().board.get(this.position) == null;
    }

    @Override
    public CompoundTag getNbt() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.position;
    }

    @Override
    public ResourceLocation getId() {
        return EmiPort.id("emi:/chess/" + this.position);
    }

    @Override
    public List<Component> getTooltipText() {
        return List.of();
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ChessPiece piece = EmiChess.getBoard().get(this.position);
        if (piece != null) {
            ArrayList list = Lists.newArrayList();
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.chess.piece." + piece.color().toString().toLowerCase() + "_" + piece.type().toString().toLowerCase()))));
            Minecraft client = Minecraft.getInstance();
            if (!EmiChess.get().started) {
                if (piece.type() == PieceType.KING) {
                    Player player;
                    list.add(new ChessTooltipComponent(ChessPiece.of(PieceType.PAWN, PieceColor.BLACK), ChessPiece.of(PieceType.KING, PieceColor.BLACK), (Component)EmiPort.translatable("emi.chess.tooltip.invite")));
                    if (EmiChess.get().pending != null && (player = client.level.getPlayerByUUID(EmiChess.get().pending)) != null) {
                        list.add(new ChessTooltipComponent(ChessPiece.of(PieceType.KING, PieceColor.WHITE), ChessPiece.of(PieceType.KING, PieceColor.BLACK), (Component)EmiPort.translatable("emi.chess.tooltip.accept", player.getName())));
                        list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.chess.tooltip.decline", player.getName()))));
                    }
                }
            } else if (piece.type() == PieceType.KING && piece.color() == PieceColor.WHITE) {
                list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable("emi.chess.tooltip.restart"))));
            }
            return list;
        }
        return List.of();
    }

    @Override
    public Component getName() {
        return EmiPort.literal("Chess Piece");
    }
}

