/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.TooltipFlag;

public class JemiStack<T>
extends EmiStack {
    private final IIngredientType<T> type;
    private final IIngredientHelper<T> helper;
    public final Object base;
    public final T ingredient;
    public IIngredientRenderer<T> renderer;

    public JemiStack(IIngredientType<T> type, IIngredientHelper<T> helper, IIngredientRenderer<T> renderer, T ingredient) {
        this.type = type;
        this.helper = helper;
        this.renderer = renderer;
        this.ingredient = ingredient;
        if (type instanceof IIngredientTypeWithSubtypes) {
            IIngredientTypeWithSubtypes iitws = (IIngredientTypeWithSubtypes)type;
            this.base = iitws.getBase(ingredient);
        } else {
            this.base = helper.getUniqueId(ingredient, UidContext.Recipe);
        }
    }

    public String getJeiUid() {
        return this.helper.getUniqueId(this.ingredient, UidContext.Ingredient);
    }

    @Override
    public void render(GuiGraphics raw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        int xOff = (16 - this.renderer.getWidth()) / 2;
        int yOff = (16 - this.renderer.getHeight()) / 2;
        context.push();
        context.matrices().translate((float)(x + xOff), (float)(y + yOff), 0.0f);
        this.renderer.render(context.raw(), this.ingredient);
        context.pop();
    }

    @Override
    public JemiStack<T> copy() {
        return new JemiStack<Object>(this.type, this.helper, this.renderer, this.helper.copyIngredient(this.ingredient));
    }

    @Override
    public boolean isEmpty() {
        return !this.helper.isValidIngredient(this.ingredient);
    }

    @Override
    public CompoundTag getNbt() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.base;
    }

    @Override
    public ResourceLocation getId() {
        return this.helper.getResourceLocation(this.ingredient);
    }

    @Override
    public List<Component> getTooltipText() {
        return this.renderer.getTooltip(this.ingredient, (TooltipFlag)TooltipFlag.NORMAL);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        Minecraft client = Minecraft.getInstance();
        list.addAll(this.renderer.getTooltip(this.ingredient, (TooltipFlag)(client.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)).stream().map(EmiPort::ordered).map(ClientTooltipComponent::create).toList());
        ResourceLocation id = this.getId();
        if (EmiConfig.appendModId && id != null) {
            String mod = EmiUtil.getModName(id.getNamespace());
            list.add(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal(mod, ChatFormatting.BLUE, ChatFormatting.ITALIC))));
        }
        list.addAll(super.getTooltip());
        return list;
    }

    @Override
    public Component getName() {
        return EmiPort.literal(this.helper.getDisplayName(this.ingredient));
    }
}

