/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.mixin;

import dev.emi.emi.EmiPort;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin
extends Screen {
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int imageHeight;
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;

    private HandledScreenMixin() {
        super(null);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)}, method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    @Dynamic
    private void renderBackground(GuiGraphics raw, int mouseX, int mouseY, float delta, CallbackInfo info) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        EmiScreenManager.drawBackground(context, mouseX, mouseY, delta);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void renderForeground(GuiGraphics raw, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (EmiAgnos.isForge()) {
            return;
        }
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        context.push();
        context.matrices().translate((double)(-this.leftPos), (double)(-this.topPos), 0.0);
        EmiPort.setPositionTexShader();
        EmiScreenManager.render(context, mouseX, mouseY, delta);
        EmiScreenManager.drawForeground(context, mouseX, mouseY, delta);
        context.pop();
    }
}

